/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.file.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.StringUtil;
import com.artfess.file.model.FileStorage;
import com.artfess.file.persistence.manager.FileStorageManager;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/file/fileStorage/v1"})
@Api(tags={"\u7cfb\u7edf\u9644\u4ef6\u5b58\u50a8\u914d\u7f6e"})
@ApiGroup(group={"group_system"})
public class FileStorageController
extends BaseController<FileStorageManager, FileStorage> {
    @Resource
    FileStorageManager fileStorageManager;

    @PostMapping(value={"/listJson"})
    @ApiOperation(value="\u7cfb\u7edf\u9644\u4ef6\u5b58\u50a8\u914d\u7f6e\u5217\u8868", httpMethod="POST", notes="\u83b7\u53d6\u7cfb\u7edf\u9644\u4ef6\u5b58\u50a8\u914d\u7f6e\u5217\u8868")
    public PageList<FileStorage> list(@ApiParam(name="queryFilter", value="\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter queryFilter) throws Exception {
        return this.fileStorageManager.query(queryFilter);
    }

    @RequestMapping(value={"listNoPage"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u7cfb\u7edf\u9644\u4ef6\u5b58\u50a8\u914d\u7f6e\u5217\u8868(\u4e0d\u5206\u9875)", httpMethod="POST", notes="\u7cfb\u7edf\u9644\u4ef6\u5b58\u50a8\u914d\u7f6e\u5217\u8868(\u4e0d\u5206\u9875)")
    public PageList<FileStorage> listJsonNoPage(@ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter<FileStorage> queryFilter) throws Exception {
        PageBean pageBean = queryFilter.getPageBean();
        pageBean.setPageSize(PageBean.WITHOUT_PAGE.intValue());
        pageBean.setPage(1);
        queryFilter.setPageBean(pageBean);
        PageList fileStorageList = this.fileStorageManager.query(queryFilter);
        return fileStorageList;
    }

    @GetMapping(value={"/getJson"})
    @ApiOperation(value="\u7cfb\u7edf\u9644\u4ef6\u5b58\u50a8\u914d\u7f6e\u6570\u636e\u8be6\u60c5", httpMethod="GET", notes="\u7cfb\u7edf\u9644\u4ef6\u5b58\u50a8\u914d\u7f6e\u6570\u636e\u8be6\u60c5")
    public FileStorage get(@ApiParam(name="id", value="\u7cfb\u7edf\u9644\u4ef6\u5b58\u50a8\u914d\u7f6e\u4e1a\u52a1\u5bf9\u8c61\u4e3b\u952e", required=true) @RequestParam String id) throws Exception {
        return (FileStorage)this.fileStorageManager.get((Serializable)((Object)id));
    }

    @PostMapping(value={"save"})
    @ApiOperation(value="\u65b0\u589e,\u66f4\u65b0\u7cfb\u7edf\u9644\u4ef6\u5b58\u50a8\u914d\u7f6e\u6570\u636e", httpMethod="POST", notes="\u65b0\u589e,\u66f4\u65b0\u6d41\u7a0b\u9644\u4ef6\u4e0a\u4f20\u914d\u7f6e\u6570\u636e")
    public CommonResult<String> save(@ApiParam(name="fileStorage", value="\u7cfb\u7edf\u9644\u4ef6\u5b58\u50a8\u914d\u7f6e\u4e1a\u52a1\u5bf9\u8c61", required=true) @RequestBody FileStorage fileStorage) throws Exception {
        String msg = "\u6dfb\u52a0\u7cfb\u7edf\u9644\u4ef6\u5b58\u50a8\u914d\u7f6e\u6210\u529f";
        if (StringUtil.isEmpty((String)fileStorage.getId())) {
            this.fileStorageManager.insertFileStorage(fileStorage);
        } else {
            this.fileStorageManager.updateFileStorage(fileStorage);
            msg = "\u66f4\u65b0\u7cfb\u7edf\u9644\u4ef6\u5b58\u50a8\u914d\u7f6e\u6210\u529f";
        }
        return new CommonResult(msg);
    }

    @DeleteMapping(value={"/remove"})
    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u7cfb\u7edf\u9644\u4ef6\u5b58\u50a8\u914d\u7f6e\u8bb0\u5f55", httpMethod="DELETE", notes="\u6279\u91cf\u5220\u9664\u7cfb\u7edf\u9644\u4ef6\u5b58\u50a8\u914d\u7f6e\u8bb0\u5f55")
    public CommonResult<String> removes(String ... ids) throws Exception {
        String msg = this.fileStorageManager.deleteFileStorage(ids);
        return new CommonResult(true, msg);
    }
}

