/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.bpm.listener;

import com.artfess.base.exception.WorkFlowException;
import com.artfess.bpm.api.cmd.ActionCmd;
import com.artfess.bpm.api.constant.MultiInstanceType;
import com.artfess.bpm.api.constant.NodeStatus;
import com.artfess.bpm.api.context.ContextThreadUtil;
import com.artfess.bpm.api.event.CallSubProcessEndEvent;
import com.artfess.bpm.api.model.delegate.BpmDelegateExecution;
import com.artfess.bpm.api.model.process.task.BpmTask;
import com.artfess.bpm.natapi.inst.NatProInstanceService;
import com.artfess.bpm.natapi.task.NatTaskService;
import com.artfess.bpm.persistence.manager.BpmExeStackExecutorManager;
import com.artfess.bpm.persistence.manager.BpmExeStackManager;
import com.artfess.bpm.persistence.manager.BpmProStatusManager;
import com.artfess.bpm.persistence.model.BpmExeStack;
import com.artfess.bpm.persistence.model.BpmExeStackExecutor;
import com.artfess.bpm.persistence.model.DefaultBpmTask;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.springframework.context.ApplicationListener;
import org.springframework.core.Ordered;
import org.springframework.stereotype.Service;

@Service(value="callSubProcessEndEventListener")
public class CallSubProcessEndEventListener
implements ApplicationListener<CallSubProcessEndEvent>,
Ordered {
    @Resource
    BpmProStatusManager bpmProStatusManager;
    @Resource
    BpmExeStackManager bpmExeStackManager;
    @Resource
    BpmExeStackExecutorManager bpmExeStackExecutorManager;
    @Resource
    NatTaskService natTaskService;
    @Resource
    NatProInstanceService natProInstanceService;

    public int getOrder() {
        return 1;
    }

    public void onApplicationEvent(CallSubProcessEndEvent endEvent) {
        BpmDelegateExecution execution = (BpmDelegateExecution)endEvent.getSource();
        Integer instCount = (Integer)execution.getVariable("nrOfInstances");
        Integer completeInstCount = (Integer)execution.getVariable("nrOfCompletedInstances");
        if (instCount == null) {
            this.setVars(execution);
            this.updNodeStatus(execution);
        } else if (instCount.equals(completeInstCount)) {
            MultiInstanceType mulType = execution.multiInstanceType();
            if (MultiInstanceType.SEQUENTIAL.equals((Object)mulType)) {
                String varName = "signUsers_" + execution.getNodeId();
                execution.removeVariable(varName);
            }
            this.setVars(execution);
            this.updNodeStatus(execution);
        }
        String nodeId = execution.getNodeId();
        String nodeName = execution.getNodeName();
        String instId = (String)execution.getVariable("instanceId_");
        ActionCmd cmd = ContextThreadUtil.getActionCmd();
        DefaultBpmTask bpmTask = new DefaultBpmTask();
        DefaultBpmTask _bpmTask = (DefaultBpmTask)cmd.getTransitVars("bpmTask_");
        bpmTask.setId(execution.getId());
        bpmTask.setNodeId(nodeId);
        bpmTask.setProcDefId(_bpmTask.getProcDefId());
        bpmTask.setProcInstId(instId);
        bpmTask.setName(nodeName);
        bpmTask.setIsGateWay(true);
        ContextThreadUtil.addTask(bpmTask);
        try {
            this.bpmExeStackManager.pushStack(execution);
            this.updStack(bpmTask, cmd);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new WorkFlowException(ExceptionUtils.getRootCauseMessage((Throwable)e));
        }
    }

    private void setVars(BpmDelegateExecution execution) {
        Map<String, Object> vars = ContextThreadUtil.getCommuVars();
        String varName = "callActivityVars_" + execution.getNodeId();
        execution.setVariable(varName, vars);
    }

    private void updNodeStatus(BpmDelegateExecution execution) {
        String instId = (String)execution.getVariable("instanceId_");
        String bpmnDefId = execution.getBpmnDefId();
        String nodeId = execution.getNodeId();
        String nodeName = execution.getNodeName();
        this.bpmProStatusManager.createOrUpd(instId, bpmnDefId, nodeId, nodeName, NodeStatus.COMPLETE);
    }

    private void updStack(BpmTask bpmTask, ActionCmd cmd) {
        String token = null;
        BpmExeStack bpmExeStack = this.bpmExeStackManager.getStack(bpmTask.getProcInstId(), bpmTask.getNodeId(), token);
        if (bpmExeStack == null) {
            bpmExeStack = this.bpmExeStackManager.getStack(bpmTask.getProcInstId(), bpmTask.getNodeId(), null);
        }
        if (bpmExeStack == null) {
            return;
        }
        bpmExeStack.setEndTime(LocalDateTime.now());
        this.bpmExeStackManager.update((Model)bpmExeStack);
        BpmExeStackExecutor executor = this.bpmExeStackExecutorManager.getByTaskId(bpmTask.getId());
        cmd.addTransitVars("parentStack", (Object)bpmExeStack);
        ContextThreadUtil.putCommonVars("parentStack", (Object)bpmExeStack);
        if (executor == null) {
            List<BpmExeStackExecutor> executorList = this.bpmExeStackExecutorManager.getByStackId(bpmExeStack.getId());
            if (executorList.size() == 1) {
                executor = executorList.get(0);
            } else {
                return;
            }
        }
        executor.setAssigneeId(ContextUtil.getCurrentUserId());
        executor.setEndTime(LocalDateTime.now());
        executor.setStatus(1);
        this.bpmExeStackExecutorManager.update((Model)executor);
    }
}

