/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.bpm.plugin.task.taskcopyto.plugin;

import com.artfess.bpm.api.cmd.ActionCmd;
import com.artfess.bpm.api.context.ContextThreadUtil;
import com.artfess.bpm.api.model.process.inst.BpmProcessInstance;
import com.artfess.bpm.api.plugin.core.def.BpmTaskPluginDef;
import com.artfess.bpm.api.plugin.core.session.BpmTaskPluginSession;
import com.artfess.bpm.api.service.BpmCopyToService;
import com.artfess.bpm.plugin.core.runtime.AbstractBpmTaskPlugin;
import com.artfess.bpm.plugin.core.util.UserAssignRuleQueryHelper;
import com.artfess.bpm.plugin.task.taskcopyto.def.TaskCopyToPluginDef;
import com.artfess.bpm.plugin.task.taskcopyto.def.model.CopyToItem;
import com.artfess.bpm.plugin.task.tasknotify.helper.NotifyHelper;
import com.artfess.uc.api.model.IUser;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;

public class TaskCopyToPlugin
extends AbstractBpmTaskPlugin {
    @Resource
    private BpmCopyToService bpmCopyToService;
    @Resource
    private NotifyHelper notifyHelper;

    @Override
    public Void execute(BpmTaskPluginSession pluginSession, BpmTaskPluginDef pluginDef) throws Exception {
        Map<String, Object> variables = pluginSession.getBpmDelegateTask().getVariables();
        ActionCmd actionCmd = ContextThreadUtil.getActionCmd();
        BpmProcessInstance instance = (BpmProcessInstance)actionCmd.getTransitVars("processInstance");
        TaskCopyToPluginDef taskCopyToPluginDef = (TaskCopyToPluginDef)pluginDef;
        for (CopyToItem copyToItem : taskCopyToPluginDef.getCopyToItems()) {
            List<IUser> toUsers = UserAssignRuleQueryHelper.queryUsersWithExtract(copyToItem.getUserAssignRules(), pluginSession.getBpmDelegateTask().getVariables());
            this.bpmCopyToService.copyTo(toUsers, instance, pluginSession.getBpmDelegateTask().getTaskDefinitionKey());
            if (copyToItem.getMsgTypes().size() <= 0) continue;
            variables.put("nodeName", pluginSession.getBpmDelegateTask().getName());
            this.notifyHelper.notify(toUsers, copyToItem.getMsgTypes(), "taskComplete", variables);
        }
        return null;
    }
}

