/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.workflow.bpmModel.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.model.CommonResult;
import com.artfess.base.util.AppUtil;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.bpm.api.model.process.def.BpmProcessDef;
import com.artfess.bpm.api.model.process.nodedef.BpmNodeDef;
import com.artfess.bpm.api.plugin.core.context.BpmPluginContext;
import com.artfess.bpm.api.service.BpmDefinitionAccessor;
import com.artfess.bpm.api.service.BpmDefinitionService;
import com.artfess.bpm.engine.def.impl.handler.PluginsBpmDefXmlHandler;
import com.artfess.bpm.persistence.model.DefaultBpmProcessDefExt;
import com.artfess.bpm.plugin.execution.procnotify.context.ProcNotifyPluginContext;
import com.artfess.bpm.plugin.task.reminders.context.RemindersPluginContext;
import com.artfess.bpm.plugin.task.startnewflow.context.StartNewFlowPluginContext;
import com.artfess.bpm.plugin.task.test.context.TestPluginContext;
import com.artfess.bpm.util.BpmUtil;
import com.artfess.bpm.util.MessageUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/flow/plugins/v1/"})
@Api(tags={"\u6d41\u7a0b\u63d2\u4ef6"})
@ApiGroup(group={"group_bpm"})
public class PluginsController {
    @Resource
    BpmDefinitionService bpmDefinitionService;
    @Resource
    BpmDefinitionAccessor bpmDefinitionAccessor;

    @RequestMapping(value={"procNotifyEdit"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u7f16\u8f91\u7ed3\u675f\u6284\u9001\u9875\u9762\u6570\u636e", httpMethod="GET", notes="\u83b7\u53d6\u7f16\u8f91\u7ed3\u675f\u6284\u9001\u9875\u9762\u6570\u636e")
    public String procNotifyEdit(@ApiParam(name="defId", value="\u6d41\u7a0b\u5b9a\u4e49id", required=true) @RequestParam String defId) throws Exception {
        BpmProcessDef bpmProcessDefExt = this.bpmDefinitionAccessor.getBpmProcessDef(defId);
        DefaultBpmProcessDefExt defExt = (DefaultBpmProcessDefExt)bpmProcessDefExt.getProcessDefExt();
        ProcNotifyPluginContext procNotifyPluginContext = (ProcNotifyPluginContext)defExt.getBpmPluginContext(ProcNotifyPluginContext.class);
        String procNotifyJson = null;
        if (procNotifyPluginContext != null) {
            procNotifyJson = procNotifyPluginContext.getJson();
        }
        return procNotifyJson;
    }

    @RequestMapping(value={"procNotifySave"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fdd\u5b58\u7ed3\u675f\u6284\u9001", httpMethod="POST", notes="\u4fdd\u5b58\u7ed3\u675f\u6284\u9001")
    public CommonResult<String> procNotifySave(@ApiParam(name="defId", value="\u6d41\u7a0b\u5b9a\u4e49id", required=true) @RequestParam String defId, @ApiParam(name="procNotifyJson", value="\u529e\u7ed3\u6284\u9001\u7684json\u6570\u636e", required=true) @RequestBody String procNotifyJson) throws Exception {
        String resultMsg = null;
        BpmProcessDef bpmProcessDefExt = this.bpmDefinitionAccessor.getBpmProcessDef(defId);
        DefaultBpmProcessDefExt defExt = (DefaultBpmProcessDefExt)bpmProcessDefExt.getProcessDefExt();
        try {
            if (StringUtil.isNotEmpty((String)defId)) {
                ProcNotifyPluginContext context = new ProcNotifyPluginContext();
                context.parse(procNotifyJson);
                List<BpmPluginContext> plugins = this.changeOnePluginContextForSave(defExt.getBpmPluginContexts(), (BpmPluginContext)context);
                PluginsBpmDefXmlHandler bpmDefXmlHandler = (PluginsBpmDefXmlHandler)AppUtil.getBean(PluginsBpmDefXmlHandler.class);
                bpmDefXmlHandler.saveNodeXml(defId, null, plugins);
                resultMsg = "\u529e\u7ed3\u6284\u9001\u6dfb\u52a0\u6210\u529f\uff01";
                BpmUtil.clearCacheByDefId((String)defId);
            }
            return new CommonResult(resultMsg);
        }
        catch (Exception e) {
            return new CommonResult(false, "\u529e\u7ed3\u6284\u9001\u8bbe\u7f6e\u5931\u8d25\uff01" + e.getMessage());
        }
    }

    @RequestMapping(value={"remindersJson"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u50ac\u529ejson", httpMethod="GET", notes="\u83b7\u53d6\u50ac\u529ejson")
    public Map<String, Object> remindersJson(@ApiParam(name="defId", value="\u6d41\u7a0b\u5b9a\u4e49id", required=true) @RequestParam String defId, @ApiParam(name="nodeId", value="\u8282\u70b9id", required=true) @RequestParam String nodeId) throws Exception {
        BpmNodeDef nodeDef = this.bpmDefinitionAccessor.getBpmNodeDef(defId, nodeId);
        RemindersPluginContext remindersPluginContext = (RemindersPluginContext)nodeDef.getPluginContext(RemindersPluginContext.class);
        HashMap<String, Object> json = new HashMap<String, Object>();
        Map handlerList = MessageUtil.getHandlerTypes();
        json.put("reminders", remindersPluginContext != null ? remindersPluginContext.getBpmPluginDef() : JsonUtil.toJsonNode((String)"{\"reminderList\":[]}"));
        json.put("warnSetting", "[{name:'\u84dd\u8272\u9884\u8b66',color:'blue',level:51},{name:'\u9ec4\u8272\u9884\u8b66',color:'yellow',level:52},{name:'\u7ea2\u8272\u9884\u8b66',color:'red',level:53}]");
        json.put("handlerList", handlerList);
        return json;
    }

    @RequestMapping(value={"remindersSave"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fdd\u5b58\u7ed3\u675f\u6284\u9001", httpMethod="POST", notes="\u4fdd\u5b58\u7ed3\u675f\u6284\u9001")
    public CommonResult<String> remindersSave(@ApiParam(name="defId", value="\u6d41\u7a0b\u5b9a\u4e49id", required=true) @RequestParam String defId, @ApiParam(name="nodeId", value="\u8282\u70b9id", required=true) @RequestParam String nodeId, @ApiParam(name="remindersJson", value="\u6284\u9001json", required=true) @RequestBody String remindersJson) throws Exception {
        try {
            BpmNodeDef nodeDef = this.bpmDefinitionAccessor.getBpmNodeDef(defId, nodeId);
            RemindersPluginContext context = new RemindersPluginContext();
            context.parse(remindersJson);
            List<BpmPluginContext> plugins = this.changeOnePluginContextForSave(nodeDef.getBpmPluginContexts(), (BpmPluginContext)context);
            PluginsBpmDefXmlHandler bpmDefXmlHandler = (PluginsBpmDefXmlHandler)AppUtil.getBean(PluginsBpmDefXmlHandler.class);
            bpmDefXmlHandler.saveNodeXml(defId, nodeId, plugins);
            BpmUtil.clearCacheByDefId((String)defId);
            return new CommonResult("\u4fdd\u5b58\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
            return new CommonResult(false, "\u4fdd\u5b58\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    private List<BpmPluginContext> changeOnePluginContextForSave(List<BpmPluginContext> contexts, BpmPluginContext pluginContext) {
        ArrayList<BpmPluginContext> bpmPluginContexts = new ArrayList<BpmPluginContext>();
        bpmPluginContexts.add(pluginContext);
        if (BeanUtils.isEmpty(contexts)) {
            return bpmPluginContexts;
        }
        for (BpmPluginContext context : contexts) {
            if (context.getClass().isAssignableFrom(pluginContext.getClass())) continue;
            bpmPluginContexts.add(context);
        }
        return bpmPluginContexts;
    }

    @RequestMapping(value={"getTestPlugin"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u6d4b\u8bd5\u63d2\u4ef6json", httpMethod="GET", notes="\u83b7\u53d6\u6d4b\u8bd5\u63d2\u4ef6json")
    public String getTestPlugin(@ApiParam(name="defId", value="\u6d41\u7a0b\u5b9a\u4e49id", required=true) @RequestParam String defId, @ApiParam(name="nodeId", value="\u8282\u70b9id", required=true) @RequestParam String nodeId) throws Exception {
        BpmNodeDef nodeDef = this.bpmDefinitionAccessor.getBpmNodeDef(defId, nodeId);
        TestPluginContext remindersPluginContext = (TestPluginContext)nodeDef.getPluginContext(TestPluginContext.class);
        if (BeanUtils.isEmpty((Object)remindersPluginContext)) {
            return "";
        }
        return remindersPluginContext.getJson();
    }

    @RequestMapping(value={"saveTestPlugin"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fdd\u5b58\u6d4b\u8bd5\u63d2\u4ef6", httpMethod="POST", notes="\u4fdd\u5b58\u6d4b\u8bd5\u63d2\u4ef6")
    public CommonResult<String> saveTestPlugin(@ApiParam(name="defId", value="\u6d41\u7a0b\u5b9a\u4e49id", required=true) @RequestParam String defId, @ApiParam(name="nodeId", value="\u8282\u70b9id", required=true) @RequestParam String nodeId, @ApiParam(name="json", value="json", required=true) @RequestBody String json) throws Exception {
        try {
            BpmNodeDef nodeDef = this.bpmDefinitionAccessor.getBpmNodeDef(defId, nodeId);
            TestPluginContext context = new TestPluginContext();
            context.parse(json);
            List<BpmPluginContext> plugins = this.changeOnePluginContextForSave(nodeDef.getBpmPluginContexts(), (BpmPluginContext)context);
            PluginsBpmDefXmlHandler bpmDefXmlHandler = (PluginsBpmDefXmlHandler)AppUtil.getBean(PluginsBpmDefXmlHandler.class);
            bpmDefXmlHandler.saveNodeXml(defId, nodeId, plugins);
            return new CommonResult("\u4fdd\u5b58\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
            return new CommonResult(false, "\u4fdd\u5b58\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    @RequestMapping(value={"startNewFlowJson"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u89e6\u53d1\u65b0\u6d41\u7a0bjson", httpMethod="GET", notes="\u83b7\u53d6\u89e6\u53d1\u65b0\u6d41\u7a0bjson")
    public String startNewFlowJson(@ApiParam(name="defId", value="\u6d41\u7a0b\u5b9a\u4e49id", required=true) @RequestParam String defId, @ApiParam(name="nodeId", value="\u8282\u70b9id", required=true) @RequestParam String nodeId) throws Exception {
        BpmNodeDef nodeDef = this.bpmDefinitionAccessor.getBpmNodeDef(defId, nodeId);
        StartNewFlowPluginContext context = (StartNewFlowPluginContext)nodeDef.getPluginContext(StartNewFlowPluginContext.class);
        return context != null ? context.getJson() : "";
    }

    @RequestMapping(value={"startNewFlowSave"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fdd\u5b58\u7ed3\u675f\u6284\u9001", httpMethod="POST", notes="\u4fdd\u5b58\u7ed3\u675f\u6284\u9001")
    public CommonResult<String> startNewFlowSave(@ApiParam(name="defId", value="\u6d41\u7a0b\u5b9a\u4e49id", required=true) @RequestParam String defId, @ApiParam(name="nodeId", value="\u8282\u70b9id", required=true) @RequestParam String nodeId, @ApiParam(name="json", value="\u914d\u7f6ejson", required=true) @RequestBody String json) throws Exception {
        try {
            BpmNodeDef nodeDef = this.bpmDefinitionAccessor.getBpmNodeDef(defId, nodeId);
            StartNewFlowPluginContext context = new StartNewFlowPluginContext();
            context.parse(json);
            List<BpmPluginContext> plugins = this.changeOnePluginContextForSave(nodeDef.getBpmPluginContexts(), (BpmPluginContext)context);
            PluginsBpmDefXmlHandler bpmDefXmlHandler = (PluginsBpmDefXmlHandler)AppUtil.getBean(PluginsBpmDefXmlHandler.class);
            bpmDefXmlHandler.saveNodeXml(defId, nodeId, plugins);
            BpmUtil.clearCacheByDefId((String)defId);
            return new CommonResult("\u4fdd\u5b58\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
            return new CommonResult(false, "\u4fdd\u5b58\u5931\u8d25\uff1a" + e.getMessage());
        }
    }
}

