/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.workflow.runtime.listener;

import com.artfess.base.context.BaseContext;
import com.artfess.base.util.AppUtil;
import com.artfess.base.util.Base64;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.FluentUtil;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.bpm.api.cmd.ActionCmd;
import com.artfess.bpm.api.constant.OpinionStatus;
import com.artfess.bpm.api.context.ContextThreadUtil;
import com.artfess.bpm.api.event.StartNewFlowEvent;
import com.artfess.bpm.api.model.process.inst.BpmProcessInstance;
import com.artfess.bpm.api.model.process.nodedef.BpmNodeDef;
import com.artfess.bpm.api.model.process.nodedef.ext.extmodel.UserAssignRule;
import com.artfess.bpm.api.service.BoDataService;
import com.artfess.bpm.persistence.manager.BpmDefinitionManager;
import com.artfess.bpm.persistence.manager.BpmProcessInstanceManager;
import com.artfess.bpm.persistence.model.DefaultBpmDefinition;
import com.artfess.bpm.persistence.model.DefaultBpmProcessInstance;
import com.artfess.bpm.plugin.core.util.UserAssignRuleParser;
import com.artfess.bpm.plugin.core.util.UserAssignRuleQueryHelper;
import com.artfess.bpm.plugin.task.startnewflow.context.StartNewFlowPluginContext;
import com.artfess.bpm.plugin.task.startnewflow.def.StartNewFlowPluginDef;
import com.artfess.bpm.plugin.task.startnewflow.entity.StartConfig;
import com.artfess.bpm.util.BoDataUtil;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IUser;
import com.artfess.uc.api.service.IUserService;
import com.artfess.workflow.runtime.manager.IProcessManager;
import com.artfess.workflow.runtime.params.StartFlowParamObject;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.Resource;
import org.springframework.context.ApplicationListener;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;

@Service
public class StartNewFlowEventListener
implements ApplicationListener<StartNewFlowEvent> {
    @Resource
    BoDataService boDataService;
    @Resource
    BpmDefinitionManager bpmDefinitionManager;
    @Resource
    IProcessManager iProcessService;
    @Resource
    IUserService userServiceImpl;
    @Resource
    BaseContext baseContext;

    public void onApplicationEvent(StartNewFlowEvent arg0) {
        BpmNodeDef bpmNodeDef = (BpmNodeDef)arg0.getSource();
        StartNewFlowPluginContext pluginContext = (StartNewFlowPluginContext)bpmNodeDef.getPluginContext(StartNewFlowPluginContext.class);
        if (BeanUtils.isEmpty((Object)pluginContext)) {
            return;
        }
        StartNewFlowPluginDef pluginDef = (StartNewFlowPluginDef)pluginContext.getBpmPluginDef();
        List configs = pluginDef.getStartConfigList();
        ActionCmd actionCmd = ContextThreadUtil.getActionCmd();
        ExecutorService executorService = Executors.newCachedThreadPool();
        String currentUserId = this.baseContext.getCurrentUserId();
        for (StartConfig conf : configs) {
            executorService.execute(() -> {
                try {
                    IUser userByAccount = this.userServiceImpl.getUserById(currentUserId);
                    SecurityContextHolder.getContext().setAuthentication(null);
                    ContextUtil.setCurrentUser((IUser)userByAccount);
                    this.startByConf(conf, actionCmd);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            });
        }
    }

    private void startByConf(StartConfig conf, ActionCmd actionCmd) throws Exception {
        List boDatas;
        if (!(conf.getTriggerAction().equals(actionCmd.getActionName()) || OpinionStatus.REJECT.getKey().equals(conf.getTriggerAction()) && OpinionStatus.BACK_TO_START.getKey().equals(actionCmd.getActionName()))) {
            return;
        }
        DefaultBpmDefinition mainByDefKey = this.bpmDefinitionManager.getMainByDefKey(conf.getDefKey());
        if (BeanUtils.isEmpty((Object)mainByDefKey)) {
            return;
        }
        ArrayList<UserAssignRule> rules = new ArrayList<UserAssignRule>();
        UserAssignRule rule = UserAssignRuleParser.getUserAssignRule((ObjectNode)((ObjectNode)JsonUtil.toJsonNode((String)conf.getUserRule())));
        rules.add(rule);
        Map variables = actionCmd.getVariables();
        variables.putAll(actionCmd.getTransitVars());
        List startUsers = UserAssignRuleQueryHelper.queryUsersWithExtract(rules, (Map)variables);
        if (BeanUtils.isEmpty((Object)startUsers)) {
            return;
        }
        ObjectNode oldBoData = null;
        if (StringUtil.isEmpty((String)actionCmd.getBusData())) {
            List dataByInst;
            BpmProcessInstanceManager instanceManager = (BpmProcessInstanceManager)AppUtil.getBean(BpmProcessInstanceManager.class);
            DefaultBpmProcessInstance instance = (DefaultBpmProcessInstance)instanceManager.get((Serializable)((Object)actionCmd.getInstId()));
            if (BeanUtils.isNotEmpty((Object)instance) && BeanUtils.isNotEmpty((Object)(dataByInst = this.boDataService.getDataByInst((BpmProcessInstance)instance)))) {
                oldBoData = BoDataUtil.hanlerData((String)instance.getProcDefId(), (List)dataByInst, (boolean)true);
            }
        } else {
            oldBoData = (ObjectNode)JsonUtil.toJsonNode((String)actionCmd.getBusData());
        }
        String newBusData = "";
        if (StringUtil.isNotEmpty((String)conf.getFormVarConf()) && oldBoData != null && BeanUtils.isNotEmpty((Object)(boDatas = this.boDataService.getDataByDefId(mainByDefKey.getDefId())))) {
            ObjectNode newBoData = BoDataUtil.hanlerData((String)mainByDefKey.getDefId(), (List)boDatas, (boolean)true);
            ArrayNode formVarConf = (ArrayNode)JsonUtil.toJsonNode((String)conf.getFormVarConf());
            for (JsonNode varConf : formVarConf) {
                String oldVar = JsonUtil.getString((JsonNode)varConf, (String)"oldVar");
                String newVar = JsonUtil.getString((JsonNode)varConf, (String)"newVar");
                if (StringUtil.isEmpty((String)oldVar) || StringUtil.isEmpty((String)newVar)) continue;
                String[] oldVarConf = oldVar.substring(oldVar.indexOf("\u3010") + 1, oldVar.length() - 1).split("\\.");
                String[] newVarConf = newVar.substring(newVar.indexOf("\u3010") + 1, newVar.length() - 1).split("\\.");
                if (BeanUtils.isEmpty((Object)oldBoData.get(oldVarConf[0])) || BeanUtils.isEmpty((Object)newBoData.get(newVarConf[0]))) continue;
                JsonNode oldValue = oldBoData.get(oldVarConf[0]).get(oldVarConf[1]);
                ObjectNode newData = (ObjectNode)newBoData.get(newVarConf[0]);
                if (!BeanUtils.isNotEmpty((Object)oldValue)) continue;
                newData.set(newVarConf[1], oldValue);
            }
            newBusData = Base64.getBase64((String)JsonUtil.toJson((Object)newBoData));
        }
        String url = "/runtime/instance/v1/start";
        for (IUser iUser : startUsers) {
            StartFlowParamObject paramObject = new StartFlowParamObject();
            paramObject.setData(newBusData);
            paramObject.setDefId(mainByDefKey.getId());
            System.err.println("\u542f\u52a8\u65b0\u6d41\u7a0b\uff1a" + mainByDefKey.getName() + "\u53d1\u8d77\u4eba\uff1a" + iUser.getFullname());
            paramObject.setAccount(iUser.getAccount());
            try {
                FluentUtil.postCurAppInterfaceWithHttp((String)url, (String)iUser.getAccount(), (Object)paramObject);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

