/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.uc.manager.impl;

import com.artfess.base.cache.annotation.CacheEvict;
import com.artfess.base.cache.annotation.Cacheable;
import com.artfess.base.context.BaseContext;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.AppUtil;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.StringUtil;
import com.artfess.base.util.time.DateFormatUtil;
import com.artfess.base.util.time.DateUtil;
import com.artfess.uc.dao.OrgUserDao;
import com.artfess.uc.exception.HotentHttpStatus;
import com.artfess.uc.manager.DemensionManager;
import com.artfess.uc.manager.OrgManager;
import com.artfess.uc.manager.OrgUserManager;
import com.artfess.uc.model.Demension;
import com.artfess.uc.model.Org;
import com.artfess.uc.model.OrgUser;
import com.artfess.uc.params.user.UserPolymerOrgPos;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.io.Serializable;
import java.sql.SQLException;
import java.text.ParseException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OrgUserManagerImpl
extends BaseManagerImpl<OrgUserDao, OrgUser>
implements OrgUserManager {
    protected Logger logger = LoggerFactory.getLogger(OrgUserManagerImpl.class);
    @Autowired
    DemensionManager demensionManager;
    @Autowired
    OrgManager orgService;
    @Autowired
    BaseContext baseContext;

    @Override
    @Transactional
    public int updateUserPost(String id, String relId) {
        return ((OrgUserDao)this.baseMapper).updateUserPost(id, relId, LocalDateTime.now());
    }

    @Override
    public OrgUser getOrgUser(String orgId, String userId, String relId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("orgId", orgId);
        params.put("userId", userId);
        if (StringUtil.isEmpty((String)relId)) {
            params.put("relIdNull", "");
        } else {
            params.put("relId", relId);
        }
        if (BeanUtils.isEmpty(((OrgUserDao)this.baseMapper).getByParms(params))) {
            return null;
        }
        return ((OrgUserDao)this.baseMapper).getByParms(params).get(0);
    }

    @Override
    public List<OrgUser> getListByOrgIdUserId(String orgId, String userId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("orgId", orgId);
        map.put("userId", userId);
        return ((OrgUserDao)this.baseMapper).getByParms(map);
    }

    @Override
    @Transactional
    public int removeByOrgIdUserId(String orgId, String userId) {
        return ((OrgUserDao)this.baseMapper).removeByOrgIdUserId(orgId, userId, LocalDateTime.now());
    }

    @Override
    @Transactional
    public void setMaster(String ... id) throws SQLException {
        OrgUserManager orgUserManager = (OrgUserManager)AppUtil.getBean(OrgUserManager.class);
        for (String i : id) {
            OrgUser orgUser = (OrgUser)this.get((Serializable)((Object)i));
            orgUserManager.removeUserMainOrgCache(orgUser.getUserId());
            orgUserManager.removeUserMainOrgCache("", orgUser.getUserId());
            if (orgUser.getIsMaster() == 0) {
                Org org = (Org)this.orgService.get((Serializable)((Object)orgUser.getOrgId()));
                List<OrgUser> orgUsers = ((OrgUserDao)this.baseMapper).getOrgUserMaster(orgUser.getUserId(), null);
                if (BeanUtils.isNotEmpty(orgUsers)) {
                    ((OrgUserDao)this.baseMapper).cancelUserMasterOrg(orgUser.getUserId(), org.getDemId(), LocalDateTime.now());
                }
                ((OrgUserDao)this.baseMapper).updateUserMasterOrg(i, LocalDateTime.now());
                continue;
            }
            orgUser.setIsMaster(0);
            this.update((Model)orgUser);
        }
    }

    @Override
    public List<OrgUser> getOrgUserMaster(String userId, String demId) {
        if (StringUtil.isNotEmpty((String)demId)) {
            Demension sysDemension = (Demension)this.demensionManager.get((Serializable)((Object)demId));
            if (BeanUtils.isEmpty((Object)sysDemension) && BeanUtils.isNotEmpty((Object)(sysDemension = this.demensionManager.getByCode(demId)))) {
                demId = sysDemension.getId();
            }
        } else {
            Demension sysDemension = this.demensionManager.getDefaultDemension();
            if (BeanUtils.isNotEmpty((Object)sysDemension)) {
                demId = sysDemension.getId();
            }
        }
        return ((OrgUserDao)this.baseMapper).getOrgUserMaster(userId, demId);
    }

    @Override
    public IPage<HashMap<String, Object>> getUserByGroup(QueryFilter queryFilter) {
        PageBean pageBean = queryFilter.getPageBean();
        IPage convert2iPage = this.convert2IPage(pageBean);
        if (queryFilter.getParams().containsKey("orgId")) {
            queryFilter.addFilter("org.ID_", queryFilter.getParams().get("orgId"), QueryOP.EQUAL);
        }
        queryFilter.addFilter("u.IS_DELE_", (Object)"1", QueryOP.NOT_EQUAL);
        queryFilter.addFilter("orguser.IS_DELE_", (Object)"1", QueryOP.NOT_EQUAL);
        queryFilter.addFilter("org.IS_DELE_", (Object)"1", QueryOP.NOT_EQUAL);
        return ((OrgUserDao)this.baseMapper).getUserByGroup((IPage<OrgUser>)convert2iPage, (Wrapper<OrgUser>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
    }

    @Override
    @Transactional
    public void setCharge(String userId, Boolean isCharge, String orgId) throws SQLException {
        List<OrgUser> orgUserList = this.getListByOrgIdUserId(orgId, userId);
        if (BeanUtils.isNotEmpty(orgUserList) && orgUserList.get(0).getIsCharge() != 2 && isCharge.booleanValue()) {
            ((OrgUserDao)this.baseMapper).cancleMainCharge(orgId, LocalDateTime.now());
        }
        for (int i = 0; i < orgUserList.size(); ++i) {
            if (orgUserList.get(i).getIsCharge() == 2) {
                orgUserList.get(i).setIsCharge(1);
            } else if (orgUserList.get(i).getIsCharge() == 1) {
                orgUserList.get(i).setIsCharge(0);
            } else if (orgUserList.get(i).getIsCharge() == 0) {
                orgUserList.get(i).setIsCharge(1);
            }
            if (orgUserList.get(i).getIsCharge() != 2 && isCharge.booleanValue()) {
                orgUserList.get(i).setIsCharge(2);
            }
            this.update((Model)orgUserList.get(i));
        }
    }

    @Override
    public List<OrgUser> getChargesByOrgId(String orgId, Boolean isMain) {
        Integer isCharge = null;
        if (BeanUtils.isNotEmpty((Object)isMain) && isMain.booleanValue()) {
            isCharge = 2;
        }
        return ((OrgUserDao)this.baseMapper).getChargesByOrgId(orgId, isCharge);
    }

    @Override
    public void syncValidOrgUser() {
        List orgUsers = this.getAll();
        for (OrgUser orgUser : orgUsers) {
            try {
                this.validRelIsActive(orgUser);
            }
            catch (Exception e) {
                String msg = "\u6821\u9a8c\u8bbe\u7f6e\u5c97\u4f4d\u6709\u6548\u6027\u5931\u8d25\uff0c\u7528\u6237ID:" + orgUser.getUserId() + "\uff0c\u5c97\u4f4dID\uff1a" + orgUser.getRelId() + "\uff0c\u9519\u8bef\u4fe1\u606f\uff1a" + e.getMessage();
                this.logger.error(msg);
            }
        }
    }

    @Transactional
    private void validRelIsActive(OrgUser orgUser) throws ParseException {
        long time;
        int isRelActive = 1;
        LocalDateTime startDate = orgUser.getStartDate();
        LocalDateTime endDate = orgUser.getEndDate();
        String currentDateStr = DateUtil.getCurrentTime((String)"yyyy-MM-dd");
        LocalDateTime currentDate = DateFormatUtil.parse((String)currentDateStr, (String)"yyyy-MM-dd");
        if (BeanUtils.isNotEmpty((Object)startDate) && BeanUtils.isNotEmpty((Object)endDate)) {
            if (!DateUtil.belongCalendar((LocalDateTime)currentDate, (LocalDateTime)startDate, (LocalDateTime)endDate)) {
                isRelActive = 0;
            }
        } else if (BeanUtils.isNotEmpty((Object)startDate)) {
            long time2 = DateUtil.getTime((LocalDateTime)startDate, (LocalDateTime)currentDate);
            if (time2 < 0L) {
                isRelActive = 0;
            }
        } else if (BeanUtils.isNotEmpty((Object)endDate) && (time = DateUtil.getTime((LocalDateTime)currentDate, (LocalDateTime)endDate)) < 0L) {
            isRelActive = 0;
        }
        orgUser.setIsRelActive(isRelActive);
        this.update((Model)orgUser);
    }

    @Override
    @Transactional
    public void delByOrgId(String orgId) {
        ((OrgUserDao)this.baseMapper).delByOrgId(orgId, LocalDateTime.now());
    }

    @Override
    public List<OrgUser> getByParms(Map<String, Object> params) {
        return ((OrgUserDao)this.baseMapper).getByParms(params);
    }

    @Override
    @Transactional
    public void saveOrgUser(String account, List<UserPolymerOrgPos> orgsPoses) throws Exception {
        List<OrgUser> orgUsers = ((OrgUserDao)this.baseMapper).getByAccount(account);
        HashMap<Object, OrgUser> orgMap = new HashMap<Object, OrgUser>();
        HashMap<String, OrgUser> posMap = new HashMap<String, OrgUser>();
        ArrayList<String> orgUserIds = new ArrayList<String>();
        for (OrgUser orgUser : orgUsers) {
            orgUserIds.add(orgUser.getId());
        }
        for (OrgUser orgUser : orgUsers) {
            String orgCode = orgUser.getOrgCode();
            String posCode = orgUser.getPosCode();
            for (UserPolymerOrgPos userPolymerOrgPos : orgsPoses) {
                if ("org".equals(userPolymerOrgPos.getType()) && StringUtil.isEmpty((String)posCode) && orgCode.equals(userPolymerOrgPos.getOrgCode())) {
                    orgMap.put(orgCode, orgUser);
                    orgUserIds.remove(orgUser.getId());
                }
                if (!"pos".equals(userPolymerOrgPos.getType()) || !StringUtil.isNotEmpty((String)posCode) || !posCode.equals(userPolymerOrgPos.getPosCode())) continue;
                posMap.put(posCode, orgUser);
                orgUserIds.remove(orgUser.getId());
            }
        }
        if (orgUserIds.size() > 0) {
            String[] ids = new String[orgUserIds.size()];
            orgUserIds.toArray(ids);
            this.removeByIds(ids);
        }
        ArrayList<String> orgCodeList = new ArrayList<String>();
        ArrayList<String> postCodeList = new ArrayList<String>();
        if (BeanUtils.isNotEmpty(orgsPoses)) {
            for (UserPolymerOrgPos userPolymerOrgPos : orgsPoses) {
                if ("org".equals(userPolymerOrgPos.getType())) {
                    orgCodeList.add(userPolymerOrgPos.getOrgCode());
                }
                if (!"pos".equals(userPolymerOrgPos.getType())) continue;
                postCodeList.add(userPolymerOrgPos.getPosCode());
            }
        }
        for (Object code : orgMap.keySet()) {
            orgCodeList.remove(code);
            OrgUser orgUser = (OrgUser)orgMap.get(code);
            orgUser.setIsDelete("0");
            this.update((Model)orgUser);
        }
        for (String orgCode : orgCodeList) {
            this.orgService.addUsersForOrg(orgCode, account);
        }
        for (String code : posMap.keySet()) {
            postCodeList.remove(code);
            OrgUser orgUser = (OrgUser)posMap.get(code);
            orgUser.setIsDelete("0");
            this.update((Model)orgUser);
        }
        for (String posCode : postCodeList) {
            this.orgService.saveUserPost(account, posCode);
        }
    }

    @Override
    @Transactional
    public void checkIsInActiveTime(LocalDateTime date) {
        ((OrgUserDao)this.baseMapper).checkIsInActiveTime(date, date);
    }

    @Override
    public IPage getUserOrgPage(QueryFilter queryFilter) {
        PageBean pageBean = queryFilter.getPageBean();
        IPage convert2iPage = this.convert2IPage(pageBean);
        return ((OrgUserDao)this.baseMapper).getUserOrgPage((IPage<OrgUser>)convert2iPage, (Wrapper<OrgUser>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
    }

    @Override
    @Transactional
    public CommonResult<String> deleteOrgById(String orgId, String userId) throws Exception {
        if (StringUtil.isEmpty((String)orgId)) {
            throw new RuntimeException(HotentHttpStatus.REUIRED.description() + ":\u8bf7\u4f20\u53c2\u6570\u7ec4\u7ec7ID");
        }
        if (StringUtil.isEmpty((String)userId)) {
            throw new RuntimeException(HotentHttpStatus.REUIRED.description() + ":\u8bf7\u4f20\u53c2\u6570\u7528\u6237ID");
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("userId", userId);
        params.put("orgId", orgId);
        ((OrgUserDao)this.baseMapper).deleteOrgById(params);
        return new CommonResult(true, "\u5220\u9664\u6210\u529f\uff01", (Object)"");
    }

    @Override
    @Transactional
    public void setMasterByIds(String ... ids) {
        OrgUserManager orgUserManager = (OrgUserManager)AppUtil.getBean(OrgUserManager.class);
        for (String i : ids) {
            OrgUser orgUser = (OrgUser)this.get((Serializable)((Object)i));
            orgUserManager.removeUserMainOrgCache(orgUser.getUserId());
            orgUserManager.removeUserMainOrgCache("", orgUser.getUserId());
            if (orgUser.getIsMaster() != 0) continue;
            Org org = (Org)this.orgService.get((Serializable)((Object)orgUser.getOrgId()));
            List<OrgUser> orgUsers = ((OrgUserDao)this.baseMapper).getOrgUserMaster(orgUser.getUserId(), null);
            if (BeanUtils.isNotEmpty(orgUsers)) {
                ((OrgUserDao)this.baseMapper).cancelUserMasterOrg(orgUser.getUserId(), org.getDemId(), LocalDateTime.now());
            }
            ((OrgUserDao)this.baseMapper).updateUserMasterOrg(i, LocalDateTime.now());
        }
    }

    @Override
    public List getUserByGroupList(QueryFilter queryFilter) {
        queryFilter.addFilter("u.IS_DELE_", (Object)"1", QueryOP.NOT_EQUAL);
        queryFilter.addFilter("orguser.IS_DELE_", (Object)"1", QueryOP.NOT_EQUAL);
        queryFilter.addFilter("org.IS_DELE_", (Object)"1", QueryOP.NOT_EQUAL);
        queryFilter.addFilter("ud.IS_DELE_", (Object)"1", QueryOP.NOT_EQUAL);
        QueryWrapper queryWrapper = this.convert2Wrapper(queryFilter, this.currentModelClass());
        queryWrapper.groupBy((Object)"u.id_");
        return ((OrgUserDao)this.baseMapper).getUserByGroupList((Wrapper<OrgUser>)queryWrapper);
    }

    @Override
    @Transactional
    public Integer removePhysical() {
        return ((OrgUserDao)this.baseMapper).removePhysical();
    }

    @Override
    public List<Map<String, Object>> getUserNumByOrgCode(Map<String, Object> map) {
        return ((OrgUserDao)this.baseMapper).getUserNumByOrgCode(map);
    }

    @Override
    @Transactional
    public void updateUserOrgByPostId(String id, String orgId) {
        ((OrgUserDao)this.baseMapper).updateUserOrgByPostId(id, orgId);
    }

    @Override
    public List getOrgUserData(QueryFilter queryFilter) {
        return ((OrgUserDao)this.baseMapper).getOrgUserData((Wrapper<OrgUser>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
    }

    @Override
    @Transactional
    public void removeByUserId(String id, LocalDateTime now) {
        ((OrgUserDao)this.baseMapper).removeByUserId(id, now);
    }

    @Override
    public Object getChargesByOrgId(String orgId, int i) {
        return ((OrgUserDao)this.baseMapper).getChargesByOrgId(orgId, i);
    }

    @Override
    public List<OrgUser> getByOrgCodeAndroleCode(String orgCode, String roleCode) {
        return ((OrgUserDao)this.baseMapper).getByOrgCodeAndroleCode(orgCode, roleCode);
    }

    @Override
    public List<OrgUser> getByPostCodeAndOrgCode(String orgCode, String postCode) {
        return ((OrgUserDao)this.baseMapper).getByPostCodeAndOrgCode(orgCode, postCode);
    }

    @Override
    public OrgUser getMainPostOrOrgByUserId(String userId) {
        List<OrgUser> mainPostByUserId = ((OrgUserDao)this.baseMapper).getMainPostOrOrgByUserId(userId);
        if (BeanUtils.isNotEmpty(mainPostByUserId)) {
            return mainPostByUserId.get(0);
        }
        return null;
    }

    @Override
    public void delByUserId(String userId) {
        ((OrgUserDao)this.baseMapper).delByUserId(userId);
    }

    @Override
    public boolean insertBatch(List<OrgUser> list) {
        return this.saveBatch(list);
    }

    @Override
    public void removeMores() {
        ((OrgUserDao)this.baseMapper).removeMores();
    }

    @Override
    @Cacheable(value={"bpm:uc:userPost"}, key="#userId")
    public String getCacheByKeyOrgPost(String userId) {
        return null;
    }

    @Override
    public List<OrgUser> getListPostAndJob(String userId) {
        return ((OrgUserDao)this.baseMapper).getListPostAndJob(userId);
    }

    @Override
    @CacheEvict(value={"bpm:uc:userMainOrg"}, key="#userId")
    public void removeUserMainOrgCache(String userId) {
    }

    @Override
    @CacheEvict(value={"bpm:uc:userMainOrg"}, key="#demId+'-'+#userId")
    public void removeUserMainOrgCache(String demId, String userId) {
    }
}

