/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.portal.controller;

import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.util.FileUtil;
import com.artfess.base.util.HttpUtil;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.base.util.ZipUtil;
import com.artfess.base.util.time.DateFormatUtil;
import com.artfess.sysConfig.persistence.manager.SysTagManager;
import com.artfess.sysConfig.persistence.model.SysTag;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.File;
import java.time.LocalDateTime;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@RestController
@RequestMapping(value={"/portal/sysTag/v1"})
@Api(tags={"sysTagController"})
public class SysTagController
extends BaseController<SysTagManager, SysTag> {
    @Resource
    SysTagManager sysTagManager;

    @PostMapping(value={"save"})
    @ApiOperation(value="\u65b0\u589e,\u66f4\u65b0\u7cfb\u7edf\u6807\u7b7e\u6570\u636e", httpMethod="POST", notes="\u65b0\u589e,\u66f4\u65b0\u7cfb\u7edf\u6807\u7b7e\u6570\u636e")
    public CommonResult<String> save(@ApiParam(name="sysTag", value="\u7cfb\u7edf\u6807\u7b7e\u4e1a\u52a1\u5bf9\u8c61", required=true) @RequestBody SysTag sysTag) throws Exception {
        String msg = "\u6dfb\u52a0\u7cfb\u7edf\u6807\u7b7e\u6210\u529f";
        if (StringUtil.isEmpty((String)sysTag.getId())) {
            this.sysTagManager.createWithCheck(sysTag);
        } else {
            this.sysTagManager.update((Model)sysTag);
            msg = "\u66f4\u65b0\u7cfb\u7edf\u6807\u7b7e\u6210\u529f";
        }
        return new CommonResult(msg);
    }

    @DeleteMapping(value={"/remove"})
    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u7cfb\u7edf\u6807\u7b7e\u8bb0\u5f55", httpMethod="DELETE", notes="\u6279\u91cf\u5220\u9664\u7cfb\u7edf\u6807\u7b7e\u8bb0\u5f55")
    public CommonResult<String> removes(String ... ids) throws Exception {
        this.sysTagManager.removeByIds(ids);
        return new CommonResult(true, "\u6279\u91cf\u5220\u9664\u6210\u529f");
    }

    @DeleteMapping(value={"/removeByTypeId"})
    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u7cfb\u7edf\u6807\u7b7e\u8bb0\u5f55", httpMethod="DELETE", notes="\u6839\u636e\u5206\u7c7bID\u5220\u9664\u7cfb\u7edf\u6807\u7b7e\u8bb0\u5f55")
    public CommonResult<String> removeByTypeId(@ApiParam(name="id", value="\u5206\u7c7bID", required=true) @RequestParam String id) throws Exception {
        this.sysTagManager.removeByTypeId(id);
        return new CommonResult(true, "\u5220\u9664\u6210\u529f");
    }

    @GetMapping(value={"/tags"})
    @ApiOperation(value="\u6839\u636e\u5206\u7c7bID\u83b7\u53d6\u7cfb\u7edf\u6807\u7b7e\u8bb0\u5f55", httpMethod="GET", notes="\u6839\u636e\u5206\u7c7bID\u83b7\u53d6\u7cfb\u7edf\u6807\u7b7e\u8bb0\u5f55")
    public List<SysTag> getTagsByTypeId(@ApiParam(name="id", value="\u5206\u7c7bID", required=true) @RequestParam String typeId) throws Exception {
        return this.sysTagManager.getTagsByTypeId(typeId);
    }

    @RequestMapping(value={"/export"})
    @ApiOperation(value="\u5bfc\u51fa\u7cfb\u7edf\u6807\u7b7e", httpMethod="GET", notes="\u6839\u636e\u5206\u7c7bID\u5bfc\u51fa\u7cfb\u7edf\u6807\u7b7e")
    public void export(@ApiParam(name="typeId", value="\u5206\u7c7bID", required=true) @RequestParam String typeId, HttpServletRequest request, HttpServletResponse response) throws Exception {
        List tagsByTypeId = ((SysTagManager)this.baseService).getTagsByTypeId(typeId);
        String json = JsonUtil.toJson((Object)tagsByTypeId);
        String fileName = "sysTags_" + DateFormatUtil.format((LocalDateTime)LocalDateTime.now(), (String)"yyyy_MMdd_HHmm");
        HttpUtil.downLoadFile((HttpServletRequest)request, (HttpServletResponse)response, (String)json, (String)"sysTags.json", (String)fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/import"})
    @ApiOperation(value="\u6839\u636e\u5206\u7c7bID\u5bfc\u5165\u7cfb\u7edf\u6807\u7b7e", httpMethod="GET", notes="\u6839\u636e\u5206\u7c7bID\u5bfc\u5165\u7cfb\u7edf\u6807\u7b7e")
    public CommonResult<String> importSysTag(@ApiParam(name="typeId", value="\u5206\u7c7bID", required=true) String typeId, MultipartHttpServletRequest request) throws Exception {
        MultipartFile file = request.getFile("file");
        String unZipFilePath = "";
        try {
            String rootRealPath = (FileUtil.getIoTmpdir() + "/attachFiles/unZip/").replace("/", File.separator);
            FileUtil.createFolder((String)rootRealPath, (boolean)true);
            String name = file.getOriginalFilename();
            String fileDir = StringUtil.substringBeforeLast((String)name, (String)".");
            ZipUtil.unZipFile((MultipartFile)file, (String)rootRealPath);
            unZipFilePath = rootRealPath + File.separator + fileDir;
            ((SysTagManager)this.baseService).importFile(unZipFilePath, typeId);
            CommonResult commonResult = new CommonResult(true, "\u5bfc\u5165\u6210\u529f");
            return commonResult;
        }
        catch (Exception e) {
            CommonResult commonResult = new CommonResult(false, "\u5bfc\u5165\u5931\u8d25\uff1a" + e.getMessage());
            return commonResult;
        }
        finally {
            File zipFile;
            if (StringUtil.isNotEmpty((String)unZipFilePath) && (zipFile = new File(unZipFilePath)).exists()) {
                zipFile.delete();
            }
        }
    }
}

