/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.portal.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.StringUtil;
import com.artfess.base.util.UniqueIdUtil;
import com.artfess.i18n.persistence.manager.I18nMessageTypeManager;
import com.artfess.i18n.persistence.model.I18nMessageType;
import com.artfess.i18n.util.I18nUtil;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.util.Locale;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/i18n/custom/i18nMessageType/v1/"})
@Api(tags={"\u56fd\u9645\u5316\u8bed\u79cd"})
@ApiGroup(group={"group_system"})
public class I18nMessageTypeController
extends BaseController<I18nMessageTypeManager, I18nMessageType> {
    @RequestMapping(value={"list"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u56fd\u9645\u5316\u8d44\u6e90\u652f\u6301\u7684\u8bed\u8a00\u7c7b\u578b\u5217\u8868(\u5206\u9875\u6761\u4ef6\u67e5\u8be2)\u6570\u636e", httpMethod="POST", notes="\u56fd\u9645\u5316\u8d44\u6e90\u652f\u6301\u7684\u8bed\u8a00\u7c7b\u578b\u5217\u8868(\u5206\u9875\u6761\u4ef6\u67e5\u8be2)\u6570\u636e")
    public PageList<I18nMessageType> listJson(@ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter<I18nMessageType> queryFilter) throws Exception {
        return ((I18nMessageTypeManager)this.baseService).query(queryFilter);
    }

    @RequestMapping(value={"all"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u56fd\u9645\u5316\u8d44\u6e90\u652f\u6301\u7684\u6240\u6709\u8bed\u8a00\u7c7b\u578b", httpMethod="POST", notes="\u56fd\u9645\u5316\u8d44\u6e90\u652f\u6301\u7684\u6240\u6709\u8bed\u8a00\u7c7b\u578b")
    public Object getAll() throws Exception {
        return ((I18nMessageTypeManager)this.baseService).getAllType();
    }

    @RequestMapping(value={"getJson"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u56fd\u9645\u5316\u8d44\u6e90\u652f\u6301\u7684\u8bed\u8a00\u7c7b\u578b\u660e\u7ec6\u9875\u9762", httpMethod="GET", notes="\u56fd\u9645\u5316\u8d44\u6e90\u652f\u6301\u7684\u8bed\u8a00\u7c7b\u578b\u660e\u7ec6\u9875\u9762")
    public Object getJson(@ApiParam(name="id", value="type\u5b9a\u4e49Id", required=true) @RequestParam String id) throws Exception {
        if (StringUtil.isEmpty((String)id)) {
            return new I18nMessageType();
        }
        I18nMessageType i18nMessageType = (I18nMessageType)((I18nMessageTypeManager)this.baseService).get((Serializable)((Object)id));
        return i18nMessageType;
    }

    @RequestMapping(value={"save"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fdd\u5b58\u56fd\u9645\u5316\u8d44\u6e90\u652f\u6301\u7684\u8bed\u8a00\u7c7b\u578b\u4fe1\u606f", httpMethod="POST", notes="\u4fdd\u5b58\u56fd\u9645\u5316\u8d44\u6e90\u652f\u6301\u7684\u8bed\u8a00\u7c7b\u578b\u4fe1\u606f")
    public Object save(@ApiParam(name="i18nMessageType", value="type\u7684\u5b9e\u4f53\u5b9a\u4e49", required=true) @RequestBody I18nMessageType i18nMessageType) throws Exception {
        String resultMsg = null;
        String id = i18nMessageType.getId();
        try {
            if (StringUtil.isEmpty((String)id)) {
                i18nMessageType.setId(UniqueIdUtil.getSuid());
                ((I18nMessageTypeManager)this.baseService).create((Model)i18nMessageType);
                resultMsg = I18nUtil.getMessage((String)"\u6dfb\u52a0\u6210\u529f", (Locale)LocaleContextHolder.getLocale());
            } else {
                ((I18nMessageTypeManager)this.baseService).update((Model)i18nMessageType);
                resultMsg = I18nUtil.getMessage((String)"\u66f4\u65b0\u6210\u529f", (Locale)LocaleContextHolder.getLocale());
            }
            ((I18nMessageTypeManager)this.baseService).delMessageTypeCache();
            return new CommonResult(true, resultMsg, null);
        }
        catch (Exception e) {
            resultMsg = I18nUtil.getMessage((String)"i18nMessageType.operationFail", (Locale)LocaleContextHolder.getLocale());
            return new CommonResult(false, resultMsg, null);
        }
    }

    @RequestMapping(value={"getByType"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5224\u65ad\u7c7b\u578b\u662f\u5426\u5b58\u5728", httpMethod="POST", notes="\u5224\u65ad\u7c7b\u578b\u662f\u5426\u5b58\u5728")
    public Object getByType(@ApiParam(name="type", value="\u8bed\u79cd\u7c7b\u578b", required=true) @RequestParam String type) throws Exception {
        I18nMessageType i18nMessageType = ((I18nMessageTypeManager)this.baseService).getByType(type);
        return i18nMessageType;
    }

    @RequestMapping(value={"remove"}, method={RequestMethod.DELETE}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u56fd\u9645\u5316\u8d44\u6e90\u652f\u6301\u7684\u8bed\u8a00\u7c7b\u578b\u8bb0\u5f55", httpMethod="DELETE", notes="\u6279\u91cf\u5220\u9664\u56fd\u9645\u5316\u8d44\u6e90\u652f\u6301\u7684\u8bed\u8a00\u7c7b\u578b\u8bb0\u5f55")
    public Object remove(@ApiParam(name="ids", value="type\u5b9a\u4e49ids", required=true) @RequestParam String ids) throws Exception {
        try {
            String[] aryIds = StringUtil.getStringAryByStr((String)ids);
            ((I18nMessageTypeManager)this.baseService).removeByIds(aryIds);
            ((I18nMessageTypeManager)this.baseService).delMessageTypeCache();
            return new CommonResult(true, I18nUtil.getMessage((String)"\u5220\u9664\u6210\u529f", (Locale)LocaleContextHolder.getLocale()), null);
        }
        catch (Exception e) {
            return new CommonResult(false, I18nUtil.getMessage((String)"\u5220\u9664\u6210\u529f", (Locale)LocaleContextHolder.getLocale()), null);
        }
    }
}

