/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.application.jms.impl;

import com.artfess.activemq.model.JmsMessage;
import com.artfess.application.jms.JmsHandler;
import com.artfess.application.model.MsgTemplate;
import com.artfess.application.persistence.manager.MessageLogManager;
import com.artfess.application.persistence.manager.MsgTemplateManager;
import com.artfess.application.service.impl.TemplateServiceImpl;
import com.artfess.application.util.DingTalkUtil;
import com.artfess.base.feign.UCFeignService;
import com.artfess.base.jms.JmsActor;
import com.artfess.base.jms.NoticeMessageType;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.JsonUtil;
import com.artfess.integrate.consts.DingTalkConsts;
import com.artfess.integrate.model.SysExternalUnite;
import com.artfess.integrate.persistence.manager.SysExternalUniteManager;
import com.artfess.integrate.util.DingTalkTokenUtil;
import com.dingtalk.api.DefaultDingTalkClient;
import com.dingtalk.api.request.OapiMessageCorpconversationAsyncsendV2Request;
import com.dingtalk.api.response.OapiMessageCorpconversationAsyncsendV2Response;
import com.taobao.api.TaobaoRequest;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DingTalkHandler
implements JmsHandler {
    private static final Logger logger = LoggerFactory.getLogger(DingTalkHandler.class);
    @Resource
    MessageLogManager messageLogManager;
    @Resource
    SysExternalUniteManager sysExternalUniteManager;
    @Resource
    MsgTemplateManager msgTemplateManager;
    @Resource
    TemplateServiceImpl templateServiceImpl;
    @Resource
    UCFeignService uCFeignService;

    @Override
    public String getType() {
        return NoticeMessageType.DINGTALK.key();
    }

    @Override
    public String getTitle() {
        return "\u9489\u9489\u6d88\u606f";
    }

    @Override
    public boolean getIsDefault() {
        return false;
    }

    @Override
    public boolean getSupportHtml() {
        return true;
    }

    @Override
    public boolean send(JmsMessage jmsMessage) {
        try {
            SysExternalUnite dingtalkUnite;
            List receivers = jmsMessage.getReceivers();
            String content = jmsMessage.getContent();
            content = content.replace("<p>", "");
            content = content.replace("</p>", "");
            jmsMessage.setContent(content);
            MsgTemplate msgTemplate = this.msgTemplateManager.getByKey(jmsMessage.getTemplateAlias());
            if (BeanUtils.isNotEmpty((Object)((Object)msgTemplate))) {
                jmsMessage.getExtendVars().put("templateType", msgTemplate.getTypeKey());
            }
            if (BeanUtils.isNotEmpty((Object)(dingtalkUnite = this.sysExternalUniteManager.getDingtalk()))) {
                String dingtalkIds;
                ArrayList<String> users = new ArrayList<String>();
                for (JmsActor receiver : receivers) {
                    users.add(receiver.getId());
                }
                if (BeanUtils.isNotEmpty(users) && BeanUtils.isNotEmpty((Object)(dingtalkIds = this.uCFeignService.getDingtalkIdsByUserIds(String.join((CharSequence)",", users))))) {
                    DefaultDingTalkClient client = new DefaultDingTalkClient(DingTalkConsts.getMsgSendUrl());
                    OapiMessageCorpconversationAsyncsendV2Request req = new OapiMessageCorpconversationAsyncsendV2Request();
                    req.setAgentId(Long.valueOf(dingtalkUnite.getAgentId()));
                    req.setUseridList(dingtalkIds);
                    OapiMessageCorpconversationAsyncsendV2Request.Msg msg = new OapiMessageCorpconversationAsyncsendV2Request.Msg();
                    msg.setMsgtype("action_card");
                    OapiMessageCorpconversationAsyncsendV2Request.ActionCard actionCard = new OapiMessageCorpconversationAsyncsendV2Request.ActionCard();
                    actionCard.setTitle("eip\u5ba1\u6279");
                    String cardContent = "# {0} \n {1}";
                    cardContent = MessageFormat.format(cardContent, msgTemplate.getSubject(), this.templateServiceImpl.parsePlainContent(msgTemplate, jmsMessage.getExtendVars()));
                    actionCard.setMarkdown(cardContent);
                    actionCard.setSingleTitle("\u67e5\u770b\u8be6\u60c5");
                    String url = DingTalkUtil.renderMobileUrl(jmsMessage);
                    actionCard.setSingleUrl(url);
                    msg.setActionCard(actionCard);
                    req.setMsg(msg);
                    OapiMessageCorpconversationAsyncsendV2Response rsp = (OapiMessageCorpconversationAsyncsendV2Response)client.execute((TaobaoRequest)req, DingTalkTokenUtil.getToken());
                    if (rsp.isSuccess()) {
                        this.messageLogManager.handLogByMsgHander(jmsMessage, true, JsonUtil.toJson((Object)rsp));
                    } else {
                        this.messageLogManager.handLogByMsgHander(jmsMessage, false, JsonUtil.toJson((Object)rsp));
                        logger.error(JsonUtil.toJson((Object)rsp));
                        return false;
                    }
                }
            }
            return true;
        }
        catch (Exception ex) {
            logger.error(ex.getMessage());
            this.messageLogManager.handLogByMsgHander(jmsMessage, false, ex.getMessage());
            return false;
        }
    }
}

