/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.bo.persistence.manager.impl;

import com.artfess.base.exception.BaseException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.bo.model.BoAttribute;
import com.artfess.bo.model.BoEnt;
import com.artfess.bo.persistence.dao.BoAttributeDao;
import com.artfess.bo.persistence.dao.BoEntDao;
import com.artfess.bo.persistence.manager.BoAttributeManager;
import com.artfess.bo.persistence.manager.BoDefManager;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="boAttributeManager")
public class BoAttributeManagerImpl
extends BaseManagerImpl<BoAttributeDao, BoAttribute>
implements BoAttributeManager {
    @Resource
    BoEntDao boEntDao;
    @Resource
    BoDefManager boDefManager;

    @Override
    public List<BoAttribute> getByEntId(String entId) {
        BoEnt ent = (BoEnt)((Object)this.boEntDao.selectById((Serializable)((Object)entId)));
        List<BoAttribute> list = ((BoAttributeDao)this.baseMapper).getByEntId(entId);
        for (BoAttribute attribute : list) {
            attribute.setBoEnt(ent);
        }
        return list;
    }

    @Override
    public List<BoAttribute> getByBoEnt(BoEnt boEnt) {
        List<BoAttribute> list = ((BoAttributeDao)this.baseMapper).getByEntId(boEnt.getId());
        for (BoAttribute attribute : list) {
            attribute.setBoEnt(boEnt);
        }
        return list;
    }

    @Override
    public void removeByEntId(String entId) {
        ((BoAttributeDao)this.baseMapper).removeByEntId(entId);
    }

    @Override
    public void updateAttrStatus(String json, String alias) throws IOException {
        BoAttribute boAttribute = (BoAttribute)((Object)JsonUtil.toBean((String)json, BoAttribute.class));
        if (StringUtil.isNotEmpty((String)boAttribute.getId())) {
            this.boDefManager.delBodefFromCache(alias);
            boAttribute.setStatus("hide");
            ((BoAttributeDao)this.baseMapper).updateById((Object)boAttribute);
        }
    }

    @Override
    public void recovery(String json, String alias) throws Exception {
        BoAttribute boAttribute = (BoAttribute)((Object)JsonUtil.toBean((String)json, BoAttribute.class));
        if (StringUtil.isNotEmpty((String)boAttribute.getId())) {
            this.boDefManager.delBodefFromCache(alias);
            boAttribute.setStatus("show");
            ((BoAttributeDao)this.baseMapper).updateById((Object)boAttribute);
        }
    }

    @Override
    public void deleteByDefId(String defId) {
        ((BoAttributeDao)this.baseMapper).deleteByDefId(defId);
    }

    public void create(BoAttribute attr) {
        this.validateAttrDataType(attr);
        super.create((Model)attr);
    }

    public void update(BoAttribute attr) {
        this.validateAttrDataType(attr);
        super.update((Model)attr);
    }

    private void validateAttrDataType(BoAttribute attr) {
        if (!BoAttribute.ATTR_TYPE_LIST.contains(attr.getDataType())) {
            throw new BaseException(String.format("\u5b9e\u4f53\u3010%s\u3011\u4e0b\u7684\u5b57\u6bb5\u3010%s\u3011\u6570\u636e\u7c7b\u578b\u4e3a\u3010%s\u3011\u4e0d\u7b26\u5408\u89c4\u8303\uff0c\u53ea\u80fd\u662f\u3010%s\u3011\u5176\u4e2d\u4e00\u79cd", attr.getBoEnt().getDesc(), attr.getDesc(), attr.getDataType(), StringUtil.join(BoAttribute.ATTR_TYPE_LIST)));
        }
    }
}

