/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.uc.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.context.BaseContext;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.StringUtil;
import com.artfess.uc.manager.TenantAuthManager;
import com.artfess.uc.manager.TenantManageManager;
import com.artfess.uc.manager.TenantTypeManager;
import com.artfess.uc.model.TenantAuth;
import com.artfess.uc.model.TenantManage;
import com.artfess.uc.model.TenantType;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/uc/tenantType/v1"})
@Api(tags={"\u79df\u6237\u7c7b\u578b\u7ba1\u7406"})
@ApiGroup(group={"group_uc"})
public class TenantTypeController
extends BaseController<TenantTypeManager, TenantType> {
    @Resource
    TenantTypeManager tenantTypeManager;
    @Resource
    TenantManageManager tenantManageManager;
    @Resource
    TenantAuthManager tenantAuthManager;
    @Resource
    BaseContext baseContext;

    @PostMapping(value={"/listJson"})
    @ApiOperation(value="\u79df\u6237\u7c7b\u578b\u7ba1\u7406\u6570\u636e\u5217\u8868", httpMethod="POST", notes="\u83b7\u53d6\u79df\u6237\u7c7b\u578b\u7ba1\u7406\u5217\u8868")
    public PageList<TenantType> list(@ApiParam(name="queryFilter", value="\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter queryFilter) throws Exception {
        return this.tenantTypeManager.query(queryFilter);
    }

    @GetMapping(value={"/getJson"})
    @ApiOperation(value="\u79df\u6237\u7c7b\u578b\u7ba1\u7406\u6570\u636e\u8be6\u60c5", httpMethod="GET", notes="\u79df\u6237\u7c7b\u578b\u7ba1\u7406\u6570\u636e\u8be6\u60c5")
    public TenantType get(@ApiParam(name="id", value="\u4e1a\u52a1\u5bf9\u8c61\u4e3b\u952e", required=true) @RequestParam String id) throws Exception {
        return (TenantType)this.tenantTypeManager.get((Serializable)((Object)id));
    }

    @GetMapping(value={"/getAll"})
    @ApiOperation(value="\u6839\u636e\u72b6\u6001\u83b7\u53d6\u6240\u6709\u79df\u6237\u7c7b\u578b", httpMethod="GET", notes="\u6839\u636e\u72b6\u6001\u83b7\u53d6\u6240\u6709\u79df\u6237\u7c7b\u578b")
    public List<TenantType> getAll(@ApiParam(name="status:enable\uff08\u542f\u7528\uff09\u3001disabled\uff08\u7981\u7528\uff09", value="\u72b6\u6001", required=false) @RequestParam Optional<String> status) throws Exception {
        List<String> authIds = null;
        return this.tenantTypeManager.getByStatus(status.orElse(null), authIds);
    }

    @PostMapping(value={"save"})
    @ApiOperation(value="\u65b0\u589e,\u66f4\u65b0\u79df\u6237\u7c7b\u578b\u7ba1\u7406\u6570\u636e", httpMethod="POST", notes="\u65b0\u589e,\u66f4\u65b0\u79df\u6237\u7c7b\u578b\u7ba1\u7406\u6570\u636e")
    public CommonResult<String> save(@ApiParam(name="tenantType", value="\u79df\u6237\u7c7b\u578b\u7ba1\u7406\u4e1a\u52a1\u5bf9\u8c61", required=true) @RequestBody TenantType tenantType) throws Exception {
        String msg = "\u6dfb\u52a0\u79df\u6237\u7c7b\u578b\u7ba1\u7406\u6210\u529f";
        if (StringUtil.isEmpty((String)tenantType.getId())) {
            TenantType type = this.tenantTypeManager.getByCode(tenantType.getCode());
            if (BeanUtils.isNotEmpty((Object)((Object)type))) {
                return new CommonResult(false, "\u65b0\u589e\u5931\u8d25\uff01\u79df\u6237\u7f16\u7801\u3010" + tenantType.getCode() + "\u3011\u5df2\u5b58\u5728\uff0c\u8bf7\u8f93\u5165\u5176\u4ed6\u7f16\u7801\u3002");
            }
            tenantType.setStatus("enable");
            this.tenantTypeManager.create((Model)tenantType);
        } else {
            TenantType type = (TenantType)this.tenantTypeManager.get((Serializable)((Object)tenantType.getId()));
            if (BeanUtils.isNotEmpty((Object)((Object)type)) && !type.getCode().equals(tenantType.getCode())) {
                return new CommonResult(false, "\u66f4\u65b0\u5931\u8d25\uff01\u4e0d\u80fd\u53d8\u66f4\u79df\u6237\u7f16\u7801\u3002");
            }
            this.tenantTypeManager.update((Model)tenantType);
            msg = "\u66f4\u65b0\u79df\u6237\u7c7b\u578b\u7ba1\u7406\u6210\u529f";
        }
        return new CommonResult(msg);
    }

    @PostMapping(value={"setDefault"})
    @ApiOperation(value="\u65b0\u589e,\u66f4\u65b0\u79df\u6237\u7c7b\u578b\u7ba1\u7406\u6570\u636e", httpMethod="POST", notes="\u65b0\u589e,\u66f4\u65b0\u79df\u6237\u7c7b\u578b\u7ba1\u7406\u6570\u636e")
    public CommonResult<String> setDefault(@ApiParam(name="code", value="\u79df\u6237\u7c7b\u578b\u7f16\u7801", required=true) @RequestParam String code) throws Exception {
        return this.tenantTypeManager.setDefault(code);
    }

    @DeleteMapping(value={"/remove"})
    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u79df\u6237\u7c7b\u578b\u7ba1\u7406\u8bb0\u5f55", httpMethod="DELETE", notes="\u6279\u91cf\u5220\u9664\u79df\u6237\u7c7b\u578b\u7ba1\u7406\u8bb0\u5f55")
    public CommonResult<String> removes(String ... ids) throws Exception {
        for (String id : ids) {
            TenantType type = this.get(id);
            if (BeanUtils.isNotEmpty((Object)((Object)type)) && "1".equals(type.getIsDefault())) {
                return new CommonResult(false, "\u88ab\u5220\u9664\u79df\u6237\u7c7b\u578b\u3010" + type.getName() + "\u3011\u4e3a\u9ed8\u8ba4\u79df\u6237\u7c7b\u578b\uff0c\u4e0d\u80fd\u88ab\u5220\u9664\uff01");
            }
            List<TenantManage> list = this.tenantManageManager.getByTypeId(id);
            if (!BeanUtils.isNotEmpty(list)) continue;
            return new CommonResult(false, "\u88ab\u5220\u9664\u79df\u6237\u7c7b\u578b\u3010" + type.getName() + "\u3011\u4e0b\u5df2\u5b58\u5728\u79df\u6237\uff0c\u4e0d\u80fd\u88ab\u5220\u9664\uff01");
        }
        this.tenantTypeManager.removeByIds(ids);
        return new CommonResult(true, "\u5220\u9664\u6210\u529f");
    }

    @RequestMapping(value={"checkCode"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u68c0\u67e5\u79df\u6237\u7c7b\u578b\u7f16\u7801\u662f\u5426\u5b58\u5728", httpMethod="GET", notes="\u68c0\u67e5\u79df\u6237\u7c7b\u578b\u7f16\u7801\u662f\u5426\u5b58\u5728")
    public boolean checkCode(@ApiParam(name="code", value="\u79df\u6237\u7c7b\u578b\u7f16\u7801") @RequestParam String code) throws Exception {
        TenantType type = this.tenantTypeManager.getByCode(code);
        return BeanUtils.isNotEmpty((Object)((Object)type));
    }

    private List<String> getAuthId() {
        String currentUserId = this.baseContext.getCurrentUserId();
        ArrayList<String> ids = new ArrayList<String>();
        List<TenantAuth> auths = this.tenantAuthManager.getByUserId(null, null, currentUserId);
        if (BeanUtils.isNotEmpty(auths)) {
            for (TenantAuth tenantAuth : auths) {
                if (!StringUtil.isNotEmpty((String)tenantAuth.getTenantId())) continue;
                ids.add(tenantAuth.getTypeId());
            }
        }
        if (BeanUtils.isEmpty(ids)) {
            ids.add("-1");
        }
        return ids;
    }
}

