/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cqlt.task.manager.impl;

import com.artfess.base.exception.RequiredException;
import com.artfess.base.jdbc.JdbcDaoImpl;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.StringUtil;
import com.artfess.cqlt.task.dao.SchedulerTaskDao;
import com.artfess.cqlt.task.manager.SchedulerTaskManager;
import com.artfess.cqlt.task.model.SchedulerTask;
import com.artfess.job.persistence.manager.SchedulerService;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import java.io.Serializable;
import java.util.HashMap;
import javax.annotation.Resource;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class SchedulerTaskManagerImpl
extends BaseManagerImpl<SchedulerTaskDao, SchedulerTask>
implements SchedulerTaskManager {
    @Resource
    SchedulerService schedulerService;
    @Resource
    Scheduler scheduler;
    @Resource
    JdbcDaoImpl jdbcDaoImpl;

    @Override
    public PageList<SchedulerTask> sliceQuerySchedulerTask(QueryFilter<SchedulerTask> queryFilter) {
        PageBean pageBean = queryFilter.getPageBean();
        IPage<SchedulerTask> result = ((SchedulerTaskDao)this.baseMapper).sliceQuerySchedulerTask((IPage<SchedulerTask>)this.convert2IPage(pageBean), (Wrapper<SchedulerTask>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(result);
    }

    @Override
    @Transactional
    public boolean insertSchedulerTask(SchedulerTask schedulerTask) {
        if (BeanUtils.isNotEmpty((Object)((Object)schedulerTask))) {
            if (StringUtil.isEmpty((String)schedulerTask.getTaskName())) {
                throw new RequiredException("\u6dfb\u52a0\u6570\u636e\u62bd\u53d6\u4efb\u52a1\u5931\u8d25\uff0c\u8bf7\u586b\u5199\u4efb\u52a1\u540d\u79f0\uff01");
            }
            if (StringUtil.isEmpty((String)schedulerTask.getTaskClass())) {
                throw new RequiredException("\u6dfb\u52a0\u6570\u636e\u62bd\u53d6\u4efb\u52a1\u5931\u8d25\uff0c\u8bf7\u586b\u5199\u4efb\u52a1\u6267\u884c\u7c7b\u7684\u5168\u540d\u79f0\uff01");
            }
            if (schedulerTask.getTaskRate() == null || schedulerTask.getTaskRate() <= 0 || StringUtil.isEmpty((String)schedulerTask.getTaskRateUnit())) {
                throw new RequiredException("\u6dfb\u52a0\u6570\u636e\u62bd\u53d6\u4efb\u52a1\u5931\u8d25\uff0c\u8bf7\u586b\u5199\u6267\u884c\u9891\u7387\uff01");
            }
            if (this.checkSameCode(schedulerTask.getTaskName(), schedulerTask.getId())) {
                throw new RequiredException("\u6dfb\u52a0\u6570\u636e\u62bd\u53d6\u4efb\u52a1\u5931\u8d25\uff0c\u8be5\u4efb\u52a1\u3010" + schedulerTask.getTaskName() + "\u3011\u5728\u7cfb\u7edf\u4e2d\u5df2\u5b58\u5728\uff0c\u4e0d\u80fd\u91cd\u590d\uff01");
            }
            schedulerTask.setTaskStatus("NONE");
            Integer result = ((SchedulerTaskDao)this.baseMapper).insert((Object)schedulerTask);
            return null != result && result >= 1;
        }
        return false;
    }

    @Override
    @Transactional
    public boolean updateSchedulerTask(SchedulerTask schedulerTask) throws SchedulerException {
        if (BeanUtils.isNotEmpty((Object)((Object)schedulerTask))) {
            SchedulerTask oldModelTask = (SchedulerTask)((Object)((SchedulerTaskDao)this.baseMapper).selectById((Serializable)((Object)schedulerTask.getId())));
            if ("NORMAL".equals(oldModelTask.getTaskStatus())) {
                throw new RequiredException("\u4fee\u6539\u6570\u636e\u62bd\u53d6\u4efb\u52a1\u5931\u8d25\uff0c\u4efb\u52a1\u6b63\u5728\u8fd0\u884c\uff0c\u8bf7\u5148\u505c\u6b62\uff01");
            }
            if (StringUtil.isEmpty((String)schedulerTask.getTaskName())) {
                throw new RequiredException("\u4fee\u6539\u6570\u636e\u62bd\u53d6\u4efb\u52a1\u5931\u8d25\uff0c\u8bf7\u586b\u5199\u4efb\u52a1\u540d\u79f0\uff01");
            }
            if (StringUtil.isEmpty((String)schedulerTask.getTaskClass())) {
                throw new RequiredException("\u4fee\u6539\u6570\u636e\u62bd\u53d6\u4efb\u52a1\u5931\u8d25\uff0c\u8bf7\u586b\u5199\u4efb\u52a1\u6267\u884c\u7c7b\u7684\u5168\u540d\u79f0\uff01");
            }
            if (schedulerTask.getTaskRate() == null || schedulerTask.getTaskRate() <= 0 || StringUtil.isEmpty((String)schedulerTask.getTaskRateUnit())) {
                throw new RequiredException("\u4fee\u6539\u6570\u636e\u62bd\u53d6\u4efb\u52a1\u5931\u8d25\uff0c\u8bf7\u586b\u5199\u6267\u884c\u9891\u7387\uff01");
            }
            if (this.checkSameCode(schedulerTask.getTaskName(), schedulerTask.getId())) {
                throw new RequiredException("\u4fee\u6539\u6570\u636e\u62bd\u53d6\u4efb\u52a1\u5931\u8d25\uff0c\u8be5\u4efb\u52a1\u3010" + schedulerTask.getTaskName() + "\u3011\u5728\u7cfb\u7edf\u4e2d\u5df2\u5b58\u5728\uff0c\u4e0d\u80fd\u91cd\u590d\uff01");
            }
            this.delJob(schedulerTask.getId());
            Integer result = ((SchedulerTaskDao)this.baseMapper).updateById((Object)schedulerTask);
            return null != result && result >= 1;
        }
        return false;
    }

    @Override
    @Transactional
    public boolean deleteSchedulerTaskById(String id) throws SchedulerException {
        if (StringUtil.isEmpty((String)id)) {
            throw new RequiredException("\u5220\u9664\u6570\u636e\u62bd\u53d6\u4efb\u52a1\u5931\u8d25\uff0c\u8bf7\u9009\u62e9\u8981\u5220\u9664\u7684\u4efb\u52a1\uff01");
        }
        SchedulerTask oldModelTask = (SchedulerTask)((Object)((SchedulerTaskDao)this.baseMapper).selectById((Serializable)((Object)id)));
        if ("NORMAL".equals(oldModelTask.getTaskStatus())) {
            throw new RequiredException("\u5220\u9664\u6570\u636e\u62bd\u53d6\u4efb\u52a1\u5931\u8d25\uff0c\u4efb\u52a1\u6b63\u5728\u8fd0\u884c\uff0c\u8bf7\u5148\u505c\u6b62\uff01");
        }
        this.delJob(id);
        Integer result = ((SchedulerTaskDao)this.baseMapper).deleteById((Serializable)((Object)id));
        return null != result && result >= 1;
    }

    @Override
    @Transactional
    public boolean startUpJob(String taskId) throws SchedulerException {
        if (StringUtil.isEmpty((String)taskId)) {
            return false;
        }
        SchedulerTask schedulerTask = (SchedulerTask)((Object)((SchedulerTaskDao)this.baseMapper).selectById((Serializable)((Object)taskId)));
        String keyName = schedulerTask.getTaskName() + ":" + this.scheduler.getSchedulerName();
        String className = schedulerTask.getTaskClass();
        HashMap<String, String> parameterMap = new HashMap<String, String>();
        parameterMap.put("id", taskId);
        boolean isExist = this.schedulerService.isJobExists(keyName);
        if (!isExist) {
            this.schedulerService.addJob(keyName, className, parameterMap, schedulerTask.getTaskName());
        }
        if (schedulerTask.getTaskType() == 1) {
            boolean rtn = this.schedulerService.isTriggerExists(keyName);
            if (!rtn) {
                this.schedulerService.addTrigger(keyName, keyName, schedulerTask.getTaskRate().intValue(), schedulerTask.getTaskRateUnit());
            } else {
                Trigger.TriggerState state = this.schedulerService.getTriggerState(keyName);
                if (state == Trigger.TriggerState.PAUSED) {
                    this.schedulerService.resumeTrigger(keyName);
                }
            }
        } else {
            boolean rtn = this.schedulerService.isTriggerExists(keyName);
            if (!rtn) {
                this.schedulerService.addSimpleTrigger(keyName, keyName);
            } else {
                Trigger.TriggerState state = this.schedulerService.getTriggerState(keyName);
                if (state == Trigger.TriggerState.PAUSED) {
                    this.schedulerService.resumeTrigger(keyName);
                }
            }
        }
        schedulerTask.setTaskStatus("NORMAL");
        ((SchedulerTaskDao)this.baseMapper).updateById((Object)schedulerTask);
        return true;
    }

    @Override
    @Transactional
    public boolean stopJob(String taskId) throws SchedulerException {
        if (StringUtil.isEmpty((String)taskId)) {
            return false;
        }
        SchedulerTask schedulerTask = (SchedulerTask)((Object)((SchedulerTaskDao)this.baseMapper).selectById((Serializable)((Object)taskId)));
        String keyName = schedulerTask.getTaskName() + ":" + this.scheduler.getSchedulerName();
        Trigger.TriggerState state = this.schedulerService.getTriggerState(keyName);
        if (state == Trigger.TriggerState.NORMAL) {
            this.schedulerService.pauseTrigger(keyName);
        }
        schedulerTask.setTaskStatus("PAUSED");
        ((SchedulerTaskDao)this.baseMapper).updateById((Object)schedulerTask);
        return true;
    }

    @Override
    @Transactional
    public boolean delJob(String taskId) throws SchedulerException {
        boolean isExist;
        if (StringUtil.isEmpty((String)taskId)) {
            return false;
        }
        SchedulerTask schedulerTask = (SchedulerTask)((Object)((SchedulerTaskDao)this.baseMapper).selectById((Serializable)((Object)taskId)));
        String keyName = schedulerTask.getTaskName() + ":" + this.scheduler.getSchedulerName();
        boolean rtn = this.schedulerService.isTriggerExists(keyName);
        if (rtn) {
            this.schedulerService.delTrigger(keyName);
        }
        if (isExist = this.schedulerService.isJobExists(keyName)) {
            this.schedulerService.delJob(keyName);
        }
        schedulerTask.setTaskStatus("NONE");
        ((SchedulerTaskDao)this.baseMapper).updateById((Object)schedulerTask);
        return true;
    }

    private boolean checkSameCode(String taskName, String id) {
        Assert.hasText((String)taskName, (String)"\u4efb\u52a1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"task_name_", (Object)taskName);
        queryWrapper.ne(StringUtil.isNotEmpty((String)id), (Object)"ID_", (Object)id);
        int num = ((SchedulerTaskDao)this.baseMapper).selectCount((Wrapper)queryWrapper);
        return num != 0;
    }
}

