package com.artfess.cqlt.vo;

import com.artfess.base.annotation.Excel;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * 运营--新订单数据填报详情表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2023-02-21
 */
@Data
@ApiModel(value="QfOperationNewOrdersD对象", description="运营--新订单数据填报详情表")
public class NewOrdersDetailVo extends BaseModel<NewOrdersDetailVo> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    private String id;

    @ApiModelProperty(value = "主表ID")
    private String mainId;

    @ApiModelProperty(value = "填报日期")
    private LocalDate fillDate;

    @Excel(name = "Enterprise code", column = "J")
    @ApiModelProperty(value = "企业编码")
    private String enterpriseCode;

    @Excel(name = "customer", column = "A")
    @ApiModelProperty(value = "产品")
    private String customer;

    @Excel(name = "Customer Development Center", column = "K")
    @ApiModelProperty(value = "客户研发中心")
    private String customerDevelopmentCenter;

    @Excel(name = "Model code", column = "B")
    @ApiModelProperty(value = "型号代码")
    private String modelCode;

    @Excel(name = "Model name", column = "C")
    @ApiModelProperty(value = "型号名称")
    private String modelName;

    @Excel(name = "Nomination date", column = "D")
    @ApiModelProperty(value = "提名日期")
    private LocalDate nominationDate;

    @Excel(name = "Sop", column = "E")
    @ApiModelProperty(value = "项目开始日期")
    private LocalDate sop;

    @Excel(name = "Estimated volume", column = "F")
    @ApiModelProperty(value = "每年预算产量（辆）")
    private BigDecimal estimatedVolume;

    @Excel(name = "Revenue", column = "G")
    @ApiModelProperty(value = "年化销售额(百万欧）")
    private BigDecimal revenue;

    @Excel(name = "Revenue lifetime", column = "H")
    @ApiModelProperty(value = "生命周期销售额（百万欧）")
    private BigDecimal revenueLifetime;

    @ApiModelProperty(value = "EBITDA利润率（%）")
    private BigDecimal ebitdaRate;

    @Excel(name = "Ebitda rate（%）", column = "I")
    @ApiModelProperty(value = "EBITDA利润率（%）")
    private String ebitdaRatestr;

    @ApiModelProperty(value = "最终编辑时间")
    private LocalDateTime lastTime;

}
