package com.artfess.cqlt.vo;

import com.artfess.base.annotation.Excel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * @author 黎沐华
 * @date 2023/2/24 10:45
 */
@Data
@ApiModel("萨固密集团资本性支出年度预算与完成情况填报Excel VO对象")
public class InvestExpendVo {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "id_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "主表ID")
    @TableField("main_id_")
    private String mainId;

    @Excel(name = "YearMonth", column = "B")
    @ApiModelProperty(value = "填报日期")
    @TableField("fill_date_")
    private LocalDate fillDate;

    @Excel(name = "Company", column = "A")
    @ApiModelProperty(value = "所属企业编码")
    @TableField("enterprise_code_")
    private String enterpriseCode;

    @ApiModelProperty(value = "所属企业名称")
    @TableField("enterprise_name_")
    private String enterpriseName;

    @ApiModelProperty(value = "所属企业英文名称")
    @TableField("enterprise_name_en_")
    private String enterpriseNameEn;

    @Excel(name = "Budget", column = "C")
    @ApiModelProperty(value = "年度资本性支出预算（欧元）")
    @TableField("budget_")
    private BigDecimal budget;

    @Excel(name = "Actual", column = "D")
    @ApiModelProperty(value = "年度资本性支出完成情况（欧元）")
    @TableField("actual_")
    private BigDecimal actual;


    @ApiModelProperty(value = "完成百分比")
    @TableField("completion_rate_")
    private BigDecimal completionRate;

    @Excel(name = "Completion Rate", column = "E")
    @ApiModelProperty(value = "完成百分比, 字符串（%）")
    @TableField("completion_rate_")
    private String completionRateStr;

    @ApiModelProperty(value = "最终编辑时间")
    @TableField("last_time_")
    private LocalDateTime lastTime;

}
