package com.artfess.cqlt.model;

import com.artfess.base.entity.AutoFillModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableId;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 统计分析指标库表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2023-03-30
 */
@Data
@ApiModel(value="SysSubjectTarget对象", description="统计分析指标库表")
public class SysSubjectTarget extends AutoFillModel<SysSubjectTarget> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "id_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "主题分类_ID（外键参考）")
    @TableField("subject_id_")
    private String subjectId;

    @ApiModelProperty(value = "指标密级程度（1：公开 2：内部 3：涉密）")
    @TableField("classification_")
    private String classification;

    @ApiModelProperty(value = "指标代码（唯一值）")
    @TableField("code_")
    private String code;

    @ApiModelProperty(value = "指标名称")
    @TableField("name_")
    private String name;

    @ApiModelProperty(value = "英文指标")
    @TableField("target_name_en_")
    private String targetNameEn;

    @ApiModelProperty(value = "指标计量单位（参考字典）")
    @TableField("unit_")
    private String unit;

    @ApiModelProperty(value = "指标描述&解释")
    @TableField("target_memo_")
    private String targetMemo;

    @ApiModelProperty(value = "统计纬度（1：实际值2：预算值3：累计实际值4：累计预算值）")
    @TableField("sta_lat_")
    private String staLat;

    @ApiModelProperty(value = "公式类型（0：亚洲区域，1：欧洲区域，3：美洲区域，4：增长率）")
    @TableField("analyse_type_")
    private String analyseType;

    @ApiModelProperty(value = "指标级别（1级、2级、3级）")
    @TableField("target_level_")
    private String targetLevel;

    @ApiModelProperty(value = "大屏类型（1:集团数据，2：企业数据，3：区域数据）")
    @TableField("larger_type_")
    private String largerType;

    @ApiModelProperty(value = "报表类型(1:年度横比，2:年度趋势，3:季度趋势，4:月度趋势，5:企业对比，6:数值)(多选,隔开)")
    @TableField("type_")
    private String type;

    @ApiModelProperty(value = "数据来源详细说明")
    @TableField("target_data_source_memo_")
    private String targetDataSourceMemo;

    @ApiModelProperty(value = "指标计算公式")
    @TableField("target_calculation_")
    private String targetCalculation;

    @ApiModelProperty(value = "所属业务【字典】（财务：Finance,运营：operation,投资：invest,人力：hr,资金：money）")
    @TableField("business_")
    private String business;


    @ApiModelProperty(value = "备注")
    @TableField("memo_")
    private String memo;

    @ApiModelProperty(value = "排序")
    @TableField("sn_")
    private Integer sn;

    @ApiModelProperty(value = "发布状态【字典】（0：未发布，1：已发布）")
    @TableField("flag_")
    private String flag;

    @TableLogic
    @ApiModelProperty(value = "删除标识【字典】（0：未删除，1：已删除）")
    @TableField("is_dele_")
    private String isDele;

    @ApiModelProperty(value = "父级id")
    @TableField(exist = false)
    private String parentId;

    /** -----新增字段------------------ */

    @ApiModelProperty(value = "单位换算(1:万欧 2：亿欧)")
    @TableField("conversion_unit_")
    private String conversionUnit;

    @ApiModelProperty(value = "链接主题【字典】（财务：Finance,运营：operation,投资：invest,人力：hr,资金：money）")
    @TableField("links_type_")
    private String linksType;

    @ApiModelProperty(value = "关联指标code")
    @TableField("related_code_")
    private String relatedCode;


}
