package com.artfess.cqlt.model;

import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.annotation.TableId;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 资金大屏统计宽表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2023-03-30
 */
@ApiModel(value="QfWeeklyCashStatistical对象", description="周资金大屏统计宽表")
public class QfWeeklyCashStatistical extends BaseModel<QfWeeklyCashStatistical> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "id_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "英文指标")
    @TableField("target_name_en_")
    private String targetNameEn;

    @ApiModelProperty(value = "指标名称")
    @TableField("target_name_")
    private String targetName;

    @ApiModelProperty(value = "指标单位")
    @TableField("target_unit_")
    private String targetUnit;

    @ApiModelProperty(value = "报表类型(1:年度横比，2:年度趋势，3:季度趋势，4:月度趋势，5:企业对比，6:数值)")
    @TableField("type_")
    private Integer type;

    @ApiModelProperty(value = "指标_ID")
    @TableField("target_id_")
    private String targetId;

    @ApiModelProperty(value = "年份")
    @TableField("year_")
    private Integer year;

    @ApiModelProperty(value = "周数")
    @TableField("week_")
    private Integer week;

    @ApiModelProperty(value = "企业编码")
    @TableField("enterprise_code_")
    private String enterpriseCode;

    @ApiModelProperty(value = "洲别【字典】")
    @TableField("enterprise_area_")
    private Integer enterpriseArea;

    @ApiModelProperty(value = "经营类型（1:生产企业，2：研发企业，3：其它服务企业，4：特殊企业）")
    @TableField("enterprise_type_")
    private Integer enterpriseType;

    @ApiModelProperty(value = "实际数据（千欧）")
    @TableField("actual_")
    private BigDecimal actual;

    @ApiModelProperty(value = "资金池公司汇总（千欧）")
    @TableField("company_total_")
    private BigDecimal companyTotal;

    @ApiModelProperty(value = "公司阈值（千欧）")
    @TableField("company_threshold_")
    private BigDecimal companyThreshold;

    @ApiModelProperty(value = "集团汇总（千欧）")
    @TableField("group_total_")
    private BigDecimal groupTotal;

    @ApiModelProperty(value = "集团阈值（千欧）")
    @TableField("group_threshold_")
    private BigDecimal groupThreshold;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getTargetNameEn() {
        return targetNameEn;
    }

    public void setTargetNameEn(String targetNameEn) {
        this.targetNameEn = targetNameEn;
    }

    public String getTargetName() {
        return targetName;
    }

    public void setTargetName(String targetName) {
        this.targetName = targetName;
    }

    public String getTargetUnit() {
        return targetUnit;
    }

    public void setTargetUnit(String targetUnit) {
        this.targetUnit = targetUnit;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public String getTargetId() {
        return targetId;
    }

    public void setTargetId(String targetId) {
        this.targetId = targetId;
    }

    public Integer getYear() {
        return year;
    }

    public void setYear(Integer year) {
        this.year = year;
    }

    public Integer getWeek() {
        return week;
    }

    public void setWeek(Integer week) {
        this.week = week;
    }

    public String getEnterpriseCode() {
        return enterpriseCode;
    }

    public void setEnterpriseCode(String enterpriseCode) {
        this.enterpriseCode = enterpriseCode;
    }

    public Integer getEnterpriseArea() {
        return enterpriseArea;
    }

    public void setEnterpriseArea(Integer enterpriseArea) {
        this.enterpriseArea = enterpriseArea;
    }

    public Integer getEnterpriseType() {
        return enterpriseType;
    }

    public void setEnterpriseType(Integer enterpriseType) {
        this.enterpriseType = enterpriseType;
    }

    public BigDecimal getActual() {
        return actual;
    }

    public void setActual(BigDecimal actual) {
        this.actual = actual;
    }

    public BigDecimal getCompanyTotal() {
        return companyTotal;
    }

    public void setCompanyTotal(BigDecimal companyTotal) {
        this.companyTotal = companyTotal;
    }

    public BigDecimal getCompanyThreshold() {
        return companyThreshold;
    }

    public void setCompanyThreshold(BigDecimal companyThreshold) {
        this.companyThreshold = companyThreshold;
    }

    public BigDecimal getGroupTotal() {
        return groupTotal;
    }

    public void setGroupTotal(BigDecimal groupTotal) {
        this.groupTotal = groupTotal;
    }

    public BigDecimal getGroupThreshold() {
        return groupThreshold;
    }

    public void setGroupThreshold(BigDecimal groupThreshold) {
        this.groupThreshold = groupThreshold;
    }


    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    @Override
    public String toString() {
        return "QfWeeklyCashStatistical{" +
            "id=" + id +
            ", targetNameEn=" + targetNameEn +
            ", targetName=" + targetName +
            ", targetUnit=" + targetUnit +
            ", type=" + type +
            ", targetId=" + targetId +
            ", year=" + year +
            ", week=" + week +
            ", enterpriseCode=" + enterpriseCode +
            ", enterpriseArea=" + enterpriseArea +
            ", enterpriseType=" + enterpriseType +
            ", actual=" + actual +
            ", companyTotal=" + companyTotal +
            ", companyThreshold=" + companyThreshold +
            ", groupTotal=" + groupTotal +
            ", groupThreshold=" + groupThreshold +
        "}";
    }
}
