package com.artfess.cqlt.model;

import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.annotation.TableId;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 投资-产能分布大屏统计宽表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2023-03-30
 */
@ApiModel(value="QfProductivityStatistical对象", description="投资-产能分布大屏统计宽表")
public class QfProductivityStatistical extends BaseModel<QfProductivityStatistical> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "id_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "英文指标")
    @TableField("target_name_en_")
    private String targetNameEn;

    @ApiModelProperty(value = "指标名称")
    @TableField("target_name_")
    private String targetName;

    @ApiModelProperty(value = "指标单位")
    @TableField("target_unit_")
    private String targetUnit;

    @ApiModelProperty(value = "报表类型(1:年度横比，2:年度趋势，3:季度趋势，4:月度趋势，5:企业对比，6:数值)")
    @TableField("type_")
    private Integer type;

    @ApiModelProperty(value = "指标_ID")
    @TableField("target_id_")
    private String targetId;

    @ApiModelProperty(value = "年份")
    @TableField("year_")
    private Integer year;

    @ApiModelProperty(value = "季度")
    @TableField("quarter_")
    private Integer quarter;

    @ApiModelProperty(value = "月份")
    @TableField("month_")
    private Integer month;

    @ApiModelProperty(value = "企业编码")
    @TableField("enterprise_code_")
    private String enterpriseCode;

    @ApiModelProperty(value = "洲别【字典】")
    @TableField("enterprise_area_")
    private Integer enterpriseArea;

    @ApiModelProperty(value = "经营类型（1:生产企业，2：研发企业，3：其它服务企业，4：特殊企业）")
    @TableField("enterprise_type_")
    private Integer enterpriseType;

    @ApiModelProperty(value = "产能类型(1：密炼，2：EPDM，3：TPE)")
    @TableField("fill_type_")
    private Integer fillType;

    @ApiModelProperty(value = "产线数量")
    @TableField("production_line_number_")
    private Integer productionLineNumber;

    @ApiModelProperty(value = "产能数量")
    @TableField("capacity_number_")
    private BigDecimal capacityNumber;

    @ApiModelProperty(value = "总产能")
    @TableField("total_capacity_number_")
    private BigDecimal totalCapacityNumber;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getTargetNameEn() {
        return targetNameEn;
    }

    public void setTargetNameEn(String targetNameEn) {
        this.targetNameEn = targetNameEn;
    }

    public String getTargetName() {
        return targetName;
    }

    public void setTargetName(String targetName) {
        this.targetName = targetName;
    }

    public String getTargetUnit() {
        return targetUnit;
    }

    public void setTargetUnit(String targetUnit) {
        this.targetUnit = targetUnit;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public String getTargetId() {
        return targetId;
    }

    public void setTargetId(String targetId) {
        this.targetId = targetId;
    }

    public Integer getYear() {
        return year;
    }

    public void setYear(Integer year) {
        this.year = year;
    }

    public Integer getQuarter() {
        return quarter;
    }

    public void setQuarter(Integer quarter) {
        this.quarter = quarter;
    }

    public Integer getMonth() {
        return month;
    }

    public void setMonth(Integer month) {
        this.month = month;
    }

    public String getEnterpriseCode() {
        return enterpriseCode;
    }

    public void setEnterpriseCode(String enterpriseCode) {
        this.enterpriseCode = enterpriseCode;
    }

    public Integer getEnterpriseArea() {
        return enterpriseArea;
    }

    public void setEnterpriseArea(Integer enterpriseArea) {
        this.enterpriseArea = enterpriseArea;
    }

    public Integer getEnterpriseType() {
        return enterpriseType;
    }

    public void setEnterpriseType(Integer enterpriseType) {
        this.enterpriseType = enterpriseType;
    }

    public Integer getFillType() {
        return fillType;
    }

    public void setFillType(Integer fillType) {
        this.fillType = fillType;
    }

    public Integer getProductionLineNumber() {
        return productionLineNumber;
    }

    public void setProductionLineNumber(Integer productionLineNumber) {
        this.productionLineNumber = productionLineNumber;
    }

    public BigDecimal getCapacityNumber() {
        return capacityNumber;
    }

    public void setCapacityNumber(BigDecimal capacityNumber) {
        this.capacityNumber = capacityNumber;
    }

    public BigDecimal getTotalCapacityNumber() {
        return totalCapacityNumber;
    }

    public void setTotalCapacityNumber(BigDecimal totalCapacityNumber) {
        this.totalCapacityNumber = totalCapacityNumber;
    }


    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    @Override
    public String toString() {
        return "QfProductivityStatistical{" +
            "id=" + id +
            ", targetNameEn=" + targetNameEn +
            ", targetName=" + targetName +
            ", targetUnit=" + targetUnit +
            ", type=" + type +
            ", targetId=" + targetId +
            ", year=" + year +
            ", quarter=" + quarter +
            ", month=" + month +
            ", enterpriseCode=" + enterpriseCode +
            ", enterpriseArea=" + enterpriseArea +
            ", enterpriseType=" + enterpriseType +
            ", fillType=" + fillType +
            ", productionLineNumber=" + productionLineNumber +
            ", capacityNumber=" + capacityNumber +
            ", totalCapacityNumber=" + totalCapacityNumber +
        "}";
    }
}
