package com.artfess.cqlt.model;

import com.artfess.base.annotation.Excel;
import com.artfess.base.entity.BaseModel;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.UpdateGroup;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * 运营--宏观数据填报详情表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 黎沐华
 * @since 2023-02-21
 */
@Data
@ApiModel(value="QfOperationMacrD对象", description="运营--宏观数据填报详情表  ")
public class QfOperationMacrD extends BaseModel<QfOperationMacrD> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "id_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "主表ID")
    @TableField("main_id_")
    private String mainId;

    @ApiModelProperty(value = "科目编码")
    @TableField("subject_code_")
    private String subjectCode;

    @Excel(name = "项目", column = "B")
    @ApiModelProperty(value = "项目")
    @TableField("subject_name_")
    private String subjectName;

    @ApiModelProperty(value = "科目层级")
    @TableField("subject_level_")
    private Integer subjectLevel;


    @ApiModelProperty(value = "科目英文名称")
    @TableField("subject_name_en_")
    private String subjectNameEn;


    @Excel(name = "FillData", column = "C")
    @ApiModelProperty(value = "填报数据")
    @TableField("fill_data_")
    private BigDecimal fillData;

    @Excel(name = "单位", column = "D")
    @ApiModelProperty(value = "科目计量单位位（由科目关联）")
    @TableField("subject_unit_")
    private String subjectUnit;


    @ApiModelProperty(value = "填报日期")
    @TableField("fill_date_")
    private LocalDate fillDate;

    @ApiModelProperty(value = "最终编辑时间")
    @TableField("last_time_")
    private LocalDateTime lastTime = LocalDateTime.now();

    @ApiModelProperty(value = "填报年")
    @TableField(exist = false)
    private Integer fillYear;

    @ApiModelProperty(value = "填报月")
    @TableField(exist = false)
    private Integer fillMonth;

    @ApiModelProperty(value = "填报季度")
    @TableField(exist = false)
    private Integer fillQuarter;

}
