package com.artfess.cqlt.model;

import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.annotation.TableId;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 财务主题大屏统计宽表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2023-03-30
 */
@Data
@ApiModel(value="QfFinancialStatistical对象", description="财务主题大屏统计宽表")
public class QfFinancialStatistical extends BaseModel<QfFinancialStatistical> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "id_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "英文指标")
    @TableField("target_name_en_")
    private String targetNameEn;

    @ApiModelProperty(value = "指标名称")
    @TableField("target_name_")
    private String targetName;

    @ApiModelProperty(value = "指标单位")
    @TableField("target_unit_")
    private String targetUnit;

    @ApiModelProperty(value = "指标级别（1级、2级、3级）")
    @TableField("target_level_")
    private String targetLevel;

    @ApiModelProperty(value = "报表类型(1:年度横比，2:年度趋势，3:季度趋势，4:月度趋势，5:企业对比，6:数值)")
    @TableField("type_")
    private String type;

    @ApiModelProperty(value = "大屏类型（1:集团数据，2：企业数据，3：区域数据）")
    @TableField("larger_type_")
    private String largerType;

    @ApiModelProperty(value = "统计纬度（1：实际值 2：预算值）")
    @TableField("sta_lat_")
    private String staLat;

    @ApiModelProperty(value = "公式类型（0：亚洲区域，1：欧洲区域，3：美洲区域，4：平均值，5：年初值）")
    @TableField("analyse_type_")
    private String analyseType;

    @ApiModelProperty(value = "指标_ID")
    @TableField("target_id_")
    private String targetId;

    @ApiModelProperty(value = "父级指标ID")
    @TableField("parent_target_id_")
    private String parentTargetId;

    @ApiModelProperty(value = "年份")
    @TableField("year_")
    private Integer year;

    @ApiModelProperty(value = "季度")
    @TableField("quarter_")
    private Integer quarter;

    @ApiModelProperty(value = "月份")
    @TableField("month_")
    private Integer month;

    @ApiModelProperty(value = "企业编码")
    @TableField("enterprise_code_")
    private String enterpriseCode;

    @ApiModelProperty(value = "洲别【字典】")
    @TableField("enterprise_area_")
    private Integer enterpriseArea;

    @ApiModelProperty(value = "经营类型（1:生产企业，2：研发企业，3：其它服务企业，4：特殊企业）")
    @TableField("enterprise_type_")
    private Integer enterpriseType;

    @ApiModelProperty(value = "实际值")
    @TableField("actual_")
    private BigDecimal actual;

    @ApiModelProperty(value = "预算值")
    @TableField("budget_")
    private BigDecimal budget;

    @ApiModelProperty(value = "累计实际值")
    @TableField("actual_ytd_")
    private BigDecimal actualYtd;

    @ApiModelProperty(value = "累计预算值")
    @TableField("budget_ytd_")
    private BigDecimal budgetYtd;

    @ApiModelProperty(value = "实际预算指标计算对应json")
    @TableField("target_calculation_")
    private String targetCalculation;

    @ApiModelProperty(value = "累计实际预算指标计算对应json")
    @TableField("ytd_target_calculation_")
    private String ytdTargetCalculation;

    @ApiModelProperty(value = "最终编辑时间")
    @TableField("last_time_")
    private LocalDateTime lastTime = LocalDateTime.now();

    @ApiModelProperty(value = "统计数据")
    @TableField(exist = false)
    private List<QfFinancialStatistical> data;

    @ApiModelProperty(value = "序号")
    @TableField(exist = false)
    private Integer sn;

    @ApiModelProperty(value = "计算公式")
    @TableField("temp_calculation_")
    private String tempCalculation;

    @ApiModelProperty(value = "数量")
    @TableField(exist = false)
    private Integer count;
}
