package com.artfess.cqlt.model;

import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableField;

import java.time.LocalDate;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 资金--周资金计划填报实际数据详情表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2023-03-02
 */
@Data
@ApiModel(value="QfFinanceLiquidityDetail对象", description="资金--周资金计划填报实际数据详情表")
public class QfFinanceLiquidityDetail extends BaseModel<QfFinanceLiquidityDetail> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "id_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "主表ID")
    @TableField("main_id_")
    private String mainId;

    @ApiModelProperty(value = "填报年")
    @TableField("fill_year_")
    private Integer fillYear;

    @ApiModelProperty(value = "填报周")
    @TableField("fill_week_")
    private Integer fillWeek;

    @ApiModelProperty(value = "填报类型(1：填报周，2：预测周)")
    @TableField("fill_type_")
    private Integer fillType;

    @ApiModelProperty(value = "数据类型(1：资金池公司，2：资金池公司汇总，3：资金池阈值，4：非资金池公司，5：非资金池公司汇总，" +
            "6：非资金池阈值，7：萨固密中国区公司，8：萨固密中国区汇总，9：萨固密中国区阈值，10：中国区外汇总，11：中国区外集团阈值，12：集团合计，13：集团阈值)")
    @TableField("data_type_")
    private Integer dataType;

    @ApiModelProperty(value = "填报日期")
    @TableField("fill_date_")
    private LocalDate fillDate;

    @ApiModelProperty(value = "填报周开始时间")
    @TableField("fill_start_date")
    private LocalDate fillStartDate;

    @ApiModelProperty(value = "填报周结束时间")
    @TableField("fill_end_date")
    private LocalDate fillEndDate;

    @ApiModelProperty(value = "所属企业编码")
    @TableField("enterprise_code_")
    private String enterpriseCode;

    @ApiModelProperty(value = "所属企业名称")
    @TableField("enterprise_name_")
    private String enterpriseName;

    @ApiModelProperty(value = "所属企业英文名称")
    @TableField("enterprise_name_en_")
    private String enterpriseNameEn;

    @ApiModelProperty(value = "实际数据（千欧）")
    @TableField("fill_data_")
    private BigDecimal fillData;

    @ApiModelProperty(value = "序号")
    @TableField("sn_")
    private Integer sn;

    @ApiModelProperty(value = "最终编辑时间")
    @TableField("last_time_")
    private LocalDateTime lastTime = LocalDateTime.now();

}
