package com.artfess.cqlt.model;

import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * 财务-资产负债预算汇总表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2023-03-02
 */
@Data
@ApiModel(value="QfFinanceBsBudgetS对象", description="财务-资产负债预算汇总表")
public class QfFinanceBsBudgetS extends BaseModel<QfFinanceBsBudgetS> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "id_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "主表ID")
    @TableField("main_id_")
    private String mainId;

    @ApiModelProperty(value = "填报年")
    @TableField("fill_year_")
    private Integer fillYear;

    @ApiModelProperty(value = "填报季度")
    @TableField("fill_quarter_")
    private Integer fillQuarter;

    @ApiModelProperty(value = "填报月")
    @TableField("fill_month_")
    private Integer fillMonth;

    @ApiModelProperty(value = "填报日期")
    @TableField("fill_date_")
    private LocalDate fillDate;

    @ApiModelProperty(value = "科目编码")
    @TableField("subject_code_")
    private String subjectCode;

    @ApiModelProperty(value = "科目中文名称")
    @TableField("subject_name_")
    private String subjectName;

    @ApiModelProperty(value = "科目英文名称")
    @TableField("subject_name_en_")
    private String subjectNameEn;

    @ApiModelProperty(value = "科目计量单位位（由科目关联）")
    @TableField("subject_unit_")
    private String subjectUnit;

    @ApiModelProperty(value = "当月预算数据汇总值")
    @TableField("budget_total_")
    private BigDecimal budgetTotal;

    @ApiModelProperty(value = "当月预算数据抵扣值")
    @TableField("budget_posting_")
    private BigDecimal budgetPosting;

    @ApiModelProperty(value = "当月预算数据合并值")
    @TableField("budget_consolidated_")
    private BigDecimal budgetConsolidated;

    @ApiModelProperty(value = "最终编辑时间")
    @TableField("last_time_")
    private LocalDateTime lastTime;

}
