package com.artfess.cqlt.model;

import com.artfess.base.entity.CqltTreeModel;
import com.artfess.base.model.Tree;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;

/**
 * 境外企业信息
 *
 * @company 阿特菲斯信息技术有限公司
 * @author lxk
 * @since 2023-02-10
 */

@Data
@TableName("QF_ENTERPRISE_INFO")
@ApiModel(value="QfEnterpriseInfo对象", description="境外企业信息")
public class QfEnterpriseInfo extends CqltTreeModel<QfEnterpriseInfo> implements Tree {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "企业英文名称")
    @TableField("name_en_")
    private String nameEn;

    @ApiModelProperty(value = "企业简称")
    @TableField("short_name_")
    private String shortName;

    @ApiModelProperty(value = "洲别【字典】")
    @TableField("continent_")
    private String continent;

    @ApiModelProperty(value = "注册国家【字典】")
    @TableField("country_")
    private String country;

    @ApiModelProperty(value = "城市（地区）")
    @TableField("city_")
    private String city;

    @ApiModelProperty(value = "成立时间")
    @TableField("build_date_")
    private LocalDate buildDate;

    @ApiModelProperty(value = "企业负责人")
    @TableField("liable_user_")
    private String liableUser;

    @ApiModelProperty(value = "经营类型（1:生产企业，2：研发企业，3：其它服务企业，4：特殊企业）")
    @TableField("business_type_")
    private Integer businessType;

    @ApiModelProperty(value = "企业类型（0:虚拟企业，1：真实企业）")
    @TableField("type_")
    private Integer type;

    @ApiModelProperty(value = "是否生产企业【字典】（0：不是，1：是）")
    @TableField("economy_type_")
    private Integer economyType;

    @ApiModelProperty(value = "资金池企业类型【字典】（0：资金池公司，1：非资金池公司，2：中国区公司）")
    @TableField("pool_type_")
    private Integer poolType;

    @ApiModelProperty(value = "经营状态【字典】（0：停业，1：正常，）")
    @TableField("run_status_")
    private Integer runStatus;

    @ApiModelProperty(value = "简介")
    @TableField("memo_")
    private String memo;

    @TableLogic
    @ApiModelProperty(value = "是否已删，1已删除，0未删除")
    @TableField(value = "IS_DELE_", updateStrategy = FieldStrategy.NOT_EMPTY)
    private String isDele;

    @ApiModelProperty(value = "创建人ID", hidden=true, accessMode= ApiModelProperty.AccessMode.READ_ONLY)
    @TableField(updateStrategy= FieldStrategy.NOT_NULL,value="create_by_", fill= FieldFill.INSERT, select=false)
    private String createBy;

    @ApiModelProperty(value = "创建时间", hidden=true, accessMode= ApiModelProperty.AccessMode.READ_ONLY)
    @TableField(updateStrategy=FieldStrategy.NOT_NULL,value="create_time_", fill=FieldFill.INSERT, select=true)
    private LocalDateTime createTime;

    @JsonIgnore
    @ApiModelProperty(value = "创建人组织ID", hidden=true, accessMode= ApiModelProperty.AccessMode.READ_ONLY)
    @TableField(updateStrategy= FieldStrategy.NOT_NULL,value="create_org_id_", fill= FieldFill.INSERT, select=false)
    private String createOrgId;

    @ApiModelProperty(value = "更新人ID", hidden=true, accessMode= ApiModelProperty.AccessMode.READ_ONLY)
    @TableField(updateStrategy= FieldStrategy.NOT_NULL,value="update_by_", fill= FieldFill.UPDATE, select=false)
    private String updateBy;

    @ApiModelProperty(value = "更新时间", hidden=true, accessMode= ApiModelProperty.AccessMode.READ_ONLY)
    @TableField(updateStrategy= FieldStrategy.NOT_NULL,value="update_time_", fill= FieldFill.UPDATE, select=false)
    private LocalDateTime updateTime;

    @TableField(exist=false)
    private String isParent;

    @TableField(exist=false)
    protected List<QfEnterpriseInfo> children ;

    @ApiModelProperty(value = "企业人员信息")
    @TableField(exist=false)
    private List<QfEnterpriseUsersInfo> userList;

    @ApiModelProperty(value = "去年销售收入")
    @TableField(exist=false)
    private String lastYearSales;

    @ApiModelProperty(value = "去年利润收入")
    @TableField(exist=false)
    private String lastProfitsSales;

    @Override
    public String getText() {
        return null;
    }

    @Override
    public void setChildren(List list) {
        this.children = list;
    }

    @Override
    public List getChildren() {
        return this.children;
    }

    @Override
    public void setIsParent(String isParent) {
        this.isParent=isParent;

    }

    @Override
    protected Serializable pkVal() {
        return this.id;
    }
}
