package com.artfess.cqlt.manager.impl;

import com.artfess.base.enums.DelStatusEnum;
import com.artfess.base.enums.SubjectLevelEnum;
import com.artfess.base.enums.SubjectTypeEnum;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.util.BeanUtils;
import com.artfess.cqlt.dao.QfSubjectInternationalInfoDao;
import com.artfess.cqlt.manager.QfSubjectInternationalInfoManager;
import com.artfess.cqlt.model.QfSubjectInternationalInfo;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 国际准则科目信息 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2023-02-08
 */
@Service
public class QfSubjectInternationalInfoManagerImpl extends BaseManagerImpl<QfSubjectInternationalInfoDao, QfSubjectInternationalInfo> implements QfSubjectInternationalInfoManager {

    @Override
    public List<QfSubjectInternationalInfo> getTree(QfSubjectInternationalInfo entity) {
        QueryWrapper<QfSubjectInternationalInfo> queryWrapper = new QueryWrapper();
        if (StringUtils.isNotBlank(entity.getCode())) {
            queryWrapper.like("code_", entity.getCode());
        }

        if (StringUtils.isNotBlank(entity.getName())) {
            queryWrapper.like("name_", entity.getName());
        }

        queryWrapper.eq("is_dele_", DelStatusEnum.N.getType());
        queryWrapper.orderByAsc("sn_");
        List<QfSubjectInternationalInfo> sysList = this.baseMapper.selectList(queryWrapper);
        List<QfSubjectInternationalInfo> tree = BeanUtils.listToTree(sysList);
        return tree;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean importExcel(List<QfSubjectInternationalInfo> list) {
        list.forEach(subject -> {
            subject.setLevel(SubjectLevelEnum.getType(subject.getLevel()));
//            subject.setType(SubjectTypeEnum.getType(subject.getType()));
            if("1".equals(subject.getLevel())){
                subject.setParentId("0");
            }
            QueryWrapper<QfSubjectInternationalInfo> queryWrapper = new QueryWrapper<>();
            queryWrapper.eq("code_", subject.getParentSubjectCode());
            QfSubjectInternationalInfo subjectInternationalInfo = this.baseMapper.selectOne(queryWrapper);
            if(null != subjectInternationalInfo) {
                subject.setParentId(subjectInternationalInfo.getId());
            }
            subject.setName(subject.getSubjectName());
            subject.setCode(subject.getSubjectCode());
            subject.setSn(subject.getSnn().intValue());
            this.newInsertTree(subject);
//            this.newUpdateTree(subject, subject.getName());
        });
//        boolean b = this.saveBatch(list);

        return true;
    }

    @Override
    public boolean batchUpdate() {
        QueryWrapper<QfSubjectInternationalInfo> queryWrapper = new QueryWrapper<>();
        queryWrapper.orderByAsc("create_time_");
        List<QfSubjectInternationalInfo> list = this.baseMapper.selectList(queryWrapper);
        list.forEach(subject -> {
            subject.setSn(this.getNextSequence(null));
            this.newUpdateTree(subject, subject.getName());
        });

        return true;
    }

    @Override
    public Map<String, QfSubjectInternationalInfo> getSubjectCodeMap(String type) {

        QueryWrapper<QfSubjectInternationalInfo> query = new QueryWrapper<>();
        query.eq("IS_DELE_", DelStatusEnum.N.getType());
        //获取财务相关国际科目
        query.like("type_", type);
        List<QfSubjectInternationalInfo> qfSubjectInternationalInfos = baseMapper.selectList(query);
        Map<String, QfSubjectInternationalInfo> subjectMap = qfSubjectInternationalInfos.stream().collect(Collectors.toMap(item -> item.getCode(), item -> item));
        return subjectMap;
    }

    @Override
    public List<QfSubjectInternationalInfo> findByType(String type) {
        QueryWrapper<QfSubjectInternationalInfo> query = new QueryWrapper<>();
        query.eq("IS_DELE_", DelStatusEnum.N.getType());
        query.eq("type_", type);
        return this.baseMapper.selectList(query);
    }
}
