package com.artfess.cqlt.manager.impl;

import com.artfess.base.exception.BaseException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.cqlt.dao.QfOperationReductionsMDao;
import com.artfess.cqlt.manager.QfOperationReductionsDManager;
import com.artfess.cqlt.manager.QfOperationReductionsMManager;
import com.artfess.cqlt.model.QfOperationNewOrdersM;
import com.artfess.cqlt.model.QfOperationReductionsD;
import com.artfess.cqlt.model.QfOperationReductionsM;
import com.artfess.i18n.util.I18nUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

import java.time.LocalDate;
import java.util.List;

/**
 * 运营--年降数据填报主表 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 黎沐华
 * @since 2023-02-21
 */
@Service
public class QfOperationReductionsMManagerImpl extends BaseManagerImpl<QfOperationReductionsMDao, QfOperationReductionsM> implements QfOperationReductionsMManager {

    @Autowired
    private QfOperationReductionsDManager operationKpiDManager;


    private void processDetail(List<QfOperationReductionsD> list, String id) {
        QueryWrapper<QfOperationReductionsD> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("main_id_", id);
        operationKpiDManager.remove(queryWrapper);
        list.forEach(detail -> {
            detail.setMainId(id);
        });
        operationKpiDManager.saveBatch(list);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean importExcel(List<QfOperationReductionsD> list, String mainId) {
        QfOperationReductionsM qfOperationKpiM = this.baseMapper.selectById(mainId);
        Assert.notNull(qfOperationKpiM, I18nUtil.getMessage("filldata.notExist", LocaleContextHolder.getLocale()));
        Assert.isTrue(!"1".equals(qfOperationKpiM.getStatus()),  I18nUtil.getMessage("data_operate", LocaleContextHolder.getLocale()));
        QueryWrapper<QfOperationReductionsD> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("main_id_", mainId);
        operationKpiDManager.remove(queryWrapper);
        list.forEach(detail -> {
            detail.setMainId(mainId);
            detail.setFillDate(LocalDate.now());
        });
        boolean b = operationKpiDManager.saveBatch(list);
        return b;
    }

    @Override
    public boolean updateStatus(QfOperationReductionsM t) {
        QfOperationReductionsM qfOperationKpiM = baseMapper.selectById(t.getId());
        if(null == qfOperationKpiM) {
            return false;
        }
        qfOperationKpiM.setStatus(qfOperationKpiM.getStatus() == 0? 1:0 );
        int i = this.baseMapper.updateById(qfOperationKpiM);
        if(i > 0){
            return true;
        }
        return false;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean insertInfo(QfOperationReductionsM t) {
        QueryWrapper<QfOperationReductionsM> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("fill_year_", t.getFillYear());
        queryWrapper.eq("fill_month_", t.getFillMonth());
        queryWrapper.eq("report_id_", t.getReportId());
        List<QfOperationReductionsM> qfOperationKpiMS = this.baseMapper.selectList(queryWrapper);
        if(!CollectionUtils.isEmpty(qfOperationKpiMS)) {
            throw new BaseException(I18nUtil.getMessage("QfOperationKpiM.repeat", LocaleContextHolder.getLocale()));
        }
        int insert = this.baseMapper.insert(t);
        if(insert > 0){
            return true;
        }
        return false;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean updateInfo(QfOperationReductionsM t) {
        QueryWrapper<QfOperationReductionsM> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("fill_year_", t.getFillYear());
        queryWrapper.eq("fill_month_", t.getFillMonth());
        queryWrapper.eq("report_id_", t.getReportId());
        queryWrapper.ne("id_", t.getId());
        List<QfOperationReductionsM> qfOperationKpiMS = this.baseMapper.selectList(queryWrapper);
        if(!CollectionUtils.isEmpty(qfOperationKpiMS)) {
            throw new BaseException(I18nUtil.getMessage("QfOperationKpiM.repeat", LocaleContextHolder.getLocale()));
        }
        int insert = this.baseMapper.updateById(t);
        if(insert > 0){
            return true;
        }
        return false;
    }

}
