package com.artfess.cqlt.manager.impl;

import com.artfess.base.enums.ContinentEnum;
import com.artfess.base.enums.DelStatusEnum;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.CollectionUtils;
import com.artfess.cqlt.dao.QfEnterpriseInfoDao;
import com.artfess.cqlt.manager.QfEnterpriseInfoManager;
import com.artfess.cqlt.manager.QfFinancialStatisticalManager;
import com.artfess.cqlt.model.QfEnterpriseInfo;
import com.artfess.cqlt.vo.EnterpriseInfoVo;
import com.artfess.i18n.util.I18nUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.YearMonth;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAdjusters;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 境外企业人员信息 服务实现类
 *
 * @author lxk
 * @company 阿特菲斯信息技术有限公司
 * @since 2023-02-10
 */
@Service
public class QfEnterpriseInfoManagerImpl extends BaseManagerImpl<QfEnterpriseInfoDao, QfEnterpriseInfo> implements QfEnterpriseInfoManager {

    @Autowired
    private QfFinancialStatisticalManager qfFinancialStatisticalManager;

    @Override
    public CommonResult insertInfo(QfEnterpriseInfo info) {
        if (baseMapper.insert(info) > 0) {
            return new CommonResult<String>(true, I18nUtil.getMessage("option.success", LocaleContextHolder.getLocale()), info.getId());
        }
        return new CommonResult<String>(false, I18nUtil.getMessage("option.fail", LocaleContextHolder.getLocale()), null);
    }

    @Override
    public CommonResult updateInfoById(QfEnterpriseInfo info) {
        if (StringUtils.isEmpty(info.getId())) {
            return new CommonResult<String>(false, I18nUtil.getMessage("parameter.error", LocaleContextHolder.getLocale()), null);
        }
        if (baseMapper.updateById(info) > 0) {
            return new CommonResult<String>(true, I18nUtil.getMessage("update.success", LocaleContextHolder.getLocale()), info.getId());
        }
        return new CommonResult<String>(false, I18nUtil.getMessage("update.fail", LocaleContextHolder.getLocale()), null);
    }

    @Override
    public CommonResult<List<QfEnterpriseInfo>> getTree() {
        QueryWrapper<QfEnterpriseInfo> queryWrapper = new QueryWrapper();
        queryWrapper.eq("IS_DELE_", DelStatusEnum.N.getType());
        List<QfEnterpriseInfo> allList = baseMapper.selectList(queryWrapper);
        if (allList.size() <= 0) {
            return new CommonResult<List<QfEnterpriseInfo>>(false, I18nUtil.getMessage("data.empty", LocaleContextHolder.getLocale()), null);
        }
        List<QfEnterpriseInfo> treeList = BeanUtils.listToTree(allList);
        return new CommonResult<List<QfEnterpriseInfo>>(true, I18nUtil.getMessage("option.success", LocaleContextHolder.getLocale()), treeList);
    }

    @Override
    public Map<String, QfEnterpriseInfo> getEnterpriseInfoMap(QfEnterpriseInfo info) {
        QueryWrapper<QfEnterpriseInfo> enterpriseInfoQuery = new QueryWrapper<>();
        enterpriseInfoQuery.eq("IS_DELE_", DelStatusEnum.N.getType());
//        enterpriseInfoQuery.eq("TYPE_", 1);
        List<QfEnterpriseInfo> enterpriseInfoList = baseMapper.selectList(enterpriseInfoQuery);
        Map<String, QfEnterpriseInfo> enterpriseInfoMap = enterpriseInfoList.stream().collect(Collectors.toMap(item -> item.getCode(), item -> item));
        return enterpriseInfoMap;
    }

    @Override
    public List<EnterpriseInfoVo> getAreaTree(QueryFilter<QfEnterpriseInfo> queryFilter) {

        PageList<QfEnterpriseInfo> query = this.query(queryFilter);
        List<QfEnterpriseInfo> allList = query.getRows();
        if (CollectionUtils.isEmpty(allList)) {
            return Lists.newArrayList();
        }
        Map<String, List<QfEnterpriseInfo>> map = allList.stream().filter(b -> !StringUtils.isEmpty(b.getContinent())).collect(Collectors.groupingBy(QfEnterpriseInfo::getContinent));
        List<EnterpriseInfoVo> list = Lists.newArrayList();
        QfEnterpriseInfo group = this.getGroup();
        allList.forEach(info -> {
            if(info.getCode().equals(group.getCode())){
                EnterpriseInfoVo infoVo = new EnterpriseInfoVo();
                infoVo.setContinent(ContinentEnum.getDesc(ContinentEnum.Group.getType()));
                List<EnterpriseInfoVo> infoVos = Lists.newArrayList();
                EnterpriseInfoVo sggrVo = new EnterpriseInfoVo();
                sggrVo.setCode(group.getCode());
                sggrVo.setName(group.getName());
                sggrVo.setId(group.getId());
                infoVos.add(sggrVo);
                infoVo.setList(infoVos);
                list.add(infoVo);
            }
        });

        map.forEach((k, v) -> {
            EnterpriseInfoVo enterpriseInfoVo = new EnterpriseInfoVo();
            enterpriseInfoVo.setContinent(ContinentEnum.getDesc(k));
            List<EnterpriseInfoVo> enterpriseInfoVos = Lists.newArrayList();
            v.forEach(enterpriseInfo -> {
                EnterpriseInfoVo vo = new EnterpriseInfoVo();
                vo.setId(enterpriseInfo.getId());
                vo.setCode(enterpriseInfo.getCode());
                vo.setName(enterpriseInfo.getName());
                enterpriseInfoVos.add(vo);
            });
            enterpriseInfoVo.setList(enterpriseInfoVos);
            list.add(enterpriseInfoVo);
        });
        return list;
    }

    @Override
    public QfEnterpriseInfo findByCode(String code) {
        QueryWrapper<QfEnterpriseInfo> queryWrapper = new QueryWrapper();
        queryWrapper.eq("code_", code);
        QfEnterpriseInfo qfEnterpriseInfo = baseMapper.selectOne(queryWrapper);
        int lastYear = LocalDate.now().getYear() - 1;
        String salesCode = "FE009";
        String profitsSalesCode = "FE001";
        BigDecimal lastYearSales = qfFinancialStatisticalManager.getLastYearSales(lastYear, salesCode, code);
        if (null != lastYearSales) {
            lastYearSales = lastYearSales.divide(new BigDecimal(10000), 2, BigDecimal.ROUND_HALF_UP);
            qfEnterpriseInfo.setLastYearSales(lastYearSales + "万欧");
        }
        BigDecimal lastYearProfitsSales = qfFinancialStatisticalManager.getlastYearProfitsSales(lastYear, profitsSalesCode, code);
        if (null != lastYearProfitsSales) {
            lastYearProfitsSales = lastYearProfitsSales.divide(new BigDecimal(10000), 2, BigDecimal.ROUND_HALF_UP);
            qfEnterpriseInfo.setLastProfitsSales(lastYearProfitsSales + "万欧");
        }

        return qfEnterpriseInfo;
    }

    @Override
    public QfEnterpriseInfo getGroup() {
        QueryWrapper<QfEnterpriseInfo> enterpriseInfoQuery = new QueryWrapper<>();
        enterpriseInfoQuery.eq("IS_DELE_", DelStatusEnum.N.getType());
        enterpriseInfoQuery.eq("TYPE_", 0);
        QfEnterpriseInfo enterpriseInfo = baseMapper.selectOne(enterpriseInfoQuery);
        return enterpriseInfo;
    }
}
