package com.artfess.cqlt.manager;

import com.alibaba.fastjson.JSONObject;
import com.artfess.cqlt.model.QfFinancePlD;
import com.artfess.base.manager.BaseManager;
import com.artfess.cqlt.model.QfFinancePlM;
import com.artfess.cqlt.model.QfHrPersonM;
import com.artfess.cqlt.vo.ReportDataVo;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;

/**
 * 财务--利润填报详情表 服务类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2023-03-02
 */
public interface QfFinancePlDManager extends BaseManager<QfFinancePlD> {

    boolean batchUpdate(QfFinancePlM t);

    List<JSONObject> detailQuery(List<QfFinancePlD> rows);

    void export(HttpServletRequest request, HttpServletResponse response, List<QfFinancePlD> rows, String sheetName) throws IOException;

    List<ReportDataVo> getActualDataList(List<String> strings, Integer fillYear, Integer endMonth);

    List<QfFinancePlD> getQfDetailList(QfHrPersonM mainInfo, String subjectCode);
}
