package com.artfess.cqlt.manager;

import com.alibaba.fastjson.JSONObject;
import com.artfess.base.manager.BaseManager;
import com.artfess.cqlt.model.QfFinanceCfD;
import com.artfess.cqlt.model.QfFinanceCfM;
import com.artfess.cqlt.vo.ReportDataVo;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;

/**
 * 财务-现金流量填报详情表 服务类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2023-03-02
 */
public interface QfFinanceCfDManager extends BaseManager<QfFinanceCfD> {

    boolean batchUpdate(QfFinanceCfM t);

    List<JSONObject> detailQuery(List<QfFinanceCfD> rows);

    void export(HttpServletRequest request, HttpServletResponse response, List<QfFinanceCfD> rows, String sheetName) throws IOException;

    List<ReportDataVo> getCfDataList(List<String> strings, Integer fillYear, Integer endMonth);
}
