package com.artfess.cqlt.dao;

import com.artfess.cqlt.model.QfHrPersonD;
import com.artfess.cqlt.vo.DataInfoVo;
import com.artfess.cqlt.vo.ReportDataVo;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 人资--人员数据填报详情表 Mapper 接口
 *
 * @author min.wu
 * @company 阿特菲斯信息技术有限公司
 * @since 2023-02-27
 */
public interface QfHrPersonDDao extends BaseMapper<QfHrPersonD> {

    List<String> getEnterpriseCodeHeader(@Param("mainId") String mainId);

    List<String> getSubjectCodes(@Param("mainId") String mainId);

    List<ReportDataVo> getPersonDataList(@Param("subjectCodes") List<String> subjectCodes, @Param("fillYear") Integer fillYear, @Param("endMonth") Integer endMonth);

    List<QfHrPersonD> findBySubjectCode(@Param("vo") DataInfoVo dataInfoVo, @Param("subjectCode") String subjectCode);
}
