package com.artfess.cqlt.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.model.CommonResult;
import com.artfess.cqlt.vo.FaReportRespVo;
import com.artfess.cqlt.vo.FaTargetRespVo;
import com.artfess.cqlt.vo.ReportReqVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.artfess.base.controller.BaseController;
import com.artfess.cqlt.model.QfRzStatistical;
import com.artfess.cqlt.manager.QfRzStatisticalManager;

import java.util.List;

/**
 * 人资-大屏统计宽表 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2023-03-30
 */
@Slf4j
@RestController
@Api(tags = "大屏统计--人资主题")
@RequestMapping("/qf/rz/statistical/")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class QfRzStatisticalController extends BaseController<QfRzStatisticalManager, QfRzStatistical> {


    @PostMapping("/oneLevelData")
    @ApiOperation(value = "人资数据一级界面统计接口", response = FaTargetRespVo.class)
    public CommonResult<String> oneLevelData(@ApiParam(name = "model", value = "请求参数") @RequestBody ReportReqVo t) {
        List<FaTargetRespVo> data = baseService.data(t);
        return CommonResult.success(data, null);
    }

    @PostMapping("/fromUnderData")
    @ApiOperation("人资数据包含当前指标的年度、季度、月度报表)")
    public CommonResult<String> fromUnderData(@ApiParam(name = "model", value = "请求参数") @RequestBody ReportReqVo t) {
        List<FaTargetRespVo> data = baseService.fromUnderData(t);
        return CommonResult.success(data, null);
    }

    @PostMapping("/enterpriseData")
    @ApiOperation("根据指标id获取对应人资大屏所有企业统计信息（所有企业）")
    public CommonResult<String> enterpriseData(@ApiParam(name = "model", value = "请求参数") @RequestBody ReportReqVo t) {
        List<FaTargetRespVo> data = baseService.enterpriseData(t);
        return CommonResult.success(data, null);
    }

}
