/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cqlt.manager.impl;

import com.artfess.base.entity.CqltTreeModel;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.StringUtil;
import com.artfess.cqlt.dao.SysSubjectClassDao;
import com.artfess.cqlt.manager.SysSubjectClassManager;
import com.artfess.cqlt.manager.SysSubjectTargetManager;
import com.artfess.cqlt.model.SysSubjectClass;
import com.artfess.cqlt.model.SysSubjectTarget;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@Service
public class SysSubjectClassManagerImpl
extends BaseManagerImpl<SysSubjectClassDao, SysSubjectClass>
implements SysSubjectClassManager {
    @Autowired
    private SysSubjectTargetManager subjectTargetManager;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean importExcel(List<SysSubjectClass> list) {
        ArrayList targetList = Lists.newArrayList();
        AtomicReference<Integer> count = new AtomicReference<Integer>(0);
        list.forEach(sysSubjectClass -> {
            Integer sn = count.getAndSet((Integer)count.get() + 1);
            sysSubjectClass.setCode(sysSubjectClass.getZbCode());
            sysSubjectClass.setBusiness("hr");
            sysSubjectClass.setClassification("2");
            sysSubjectClass.setName(sysSubjectClass.getZbName());
            sysSubjectClass.setSn(sn);
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"code_", (Object)sysSubjectClass.getParentCode());
            SysSubjectClass subjectClass = (SysSubjectClass)((Object)((Object)((SysSubjectClassDao)this.baseMapper).selectOne((Wrapper)queryWrapper)));
            if (null != subjectClass) {
                sysSubjectClass.setParentId(subjectClass.getId());
            }
            this.newInsertTree((CqltTreeModel)sysSubjectClass);
            SysSubjectTarget target = new SysSubjectTarget();
            target.setCode(sysSubjectClass.getCode());
            target.setTargetNameEn(sysSubjectClass.getTargetNameEn());
            target.setName(sysSubjectClass.getName());
            target.setClassification("2");
            target.setTargetLevel(sysSubjectClass.getLevel());
            target.setUnit(sysSubjectClass.getTargetUnit());
            target.setType(sysSubjectClass.getType());
            target.setBusiness(sysSubjectClass.getBusiness());
            target.setAnalyseType(sysSubjectClass.getAnalyseType());
            target.setStaLat(sysSubjectClass.getStaLat());
            target.setMemo(sysSubjectClass.getMemo());
            target.setTargetCalculation(sysSubjectClass.getTargetCalculation());
            target.setTargetDataSourceMemo(sysSubjectClass.getTargetDataSourceMemo());
            target.setSubjectId(sysSubjectClass.getId());
            if (!StringUtil.isEmpty((String)sysSubjectClass.getRelatedCode())) {
                target.setRelatedCode(sysSubjectClass.getRelatedCode());
            }
            if (!StringUtil.isEmpty((String)sysSubjectClass.getLinksType())) {
                target.setLinksType(sysSubjectClass.getLinksType());
            }
            if (!StringUtil.isEmpty((String)sysSubjectClass.getConversionUnit())) {
                target.setConversionUnit(sysSubjectClass.getConversionUnit());
            }
            target.setSn(sn);
            targetList.add(target);
        });
        this.subjectTargetManager.saveBatch(targetList);
        return true;
    }

    @Override
    public List<SysSubjectClass> getTree(String targetId) {
        Assert.hasText((String)targetId, (String)"\u8bf7\u9009\u62e9\u6307\u6807id");
        SysSubjectClass subjectClass = ((SysSubjectClassDao)this.baseMapper).getSubjectInfo(targetId);
        if (null == subjectClass) {
            return Lists.newArrayList();
        }
        List<SysSubjectClass> list = ((SysSubjectClassDao)this.baseMapper).findByTargetId(subjectClass.getFullId().split("/")[1], null);
        this.specialHandling(subjectClass, list);
        List tree = BeanUtils.listToTree(list);
        return tree;
    }

    private void specialHandling(SysSubjectClass subjectClass, List<SysSubjectClass> list) {
        if (!"\u51c0\u8d44\u4ea7\u6536\u76ca\u7387".equals(subjectClass.getName())) {
            return;
        }
        HashMap relateTarget = Maps.newHashMap();
        ArrayList relatedCodes = Lists.newArrayList();
        list.forEach(subject -> {
            if (StringUtil.isEmpty((String)subject.getRelatedCode())) {
                return;
            }
            relateTarget.put(subject.getRelatedCode(), subject.getId());
            relatedCodes.add(subject.getRelatedCode());
        });
        List<SysSubjectClass> subjectClassList = ((SysSubjectClassDao)this.baseMapper).getSubjectList(relatedCodes);
        subjectClassList.forEach(subject -> {
            if (relateTarget.containsKey(subject.getCode())) {
                subject.setParentId((String)relateTarget.get(subject.getCode()));
            }
            list.add((SysSubjectClass)((Object)subject));
        });
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean saveInfo(SysSubjectClass t) {
        String id;
        if (t.getSn() == null) {
            t.setSn(this.getNextSequence(null));
        }
        if (StringUtil.isEmpty((String)(id = this.newInsertTree(t)))) {
            return false;
        }
        SysSubjectTarget target = new SysSubjectTarget();
        target.setCode(t.getCode());
        target.setTargetNameEn(t.getTargetNameEn());
        target.setName(t.getName());
        target.setClassification(t.getClassification());
        target.setTargetLevel(t.getLevel());
        target.setUnit(t.getTargetUnit());
        target.setType(t.getType());
        target.setBusiness(t.getBusiness());
        target.setAnalyseType(t.getAnalyseType());
        target.setStaLat(t.getStaLat());
        target.setMemo(t.getMemo());
        target.setTargetCalculation(t.getTargetCalculation());
        target.setTargetDataSourceMemo(t.getTargetDataSourceMemo());
        target.setSubjectId(t.getId());
        target.setSn(t.getSn());
        boolean save = this.subjectTargetManager.save((Object)target);
        return save;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean updateInfo(SysSubjectClass t) {
        SysSubjectClass subjectClass;
        String id;
        if (t.getSn() == null) {
            t.setSn(this.getNextSequence(null));
        }
        if (StringUtil.isEmpty((String)(id = this.newUpdateTree(t, (subjectClass = (SysSubjectClass)((Object)this.getById((Serializable)((Object)t.getId())))).getName())))) {
            return false;
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"subject_id_", (Object)id);
        SysSubjectTarget target = (SysSubjectTarget)((Object)this.subjectTargetManager.getOne((Wrapper)queryWrapper));
        if (null == target) {
            target = new SysSubjectTarget();
        }
        target.setCode(t.getCode());
        target.setTargetNameEn(t.getTargetNameEn());
        target.setName(t.getName());
        target.setClassification(t.getClassification());
        target.setTargetLevel(t.getLevel());
        target.setUnit(t.getTargetUnit());
        target.setType(t.getType());
        target.setBusiness(t.getBusiness());
        target.setAnalyseType(t.getAnalyseType());
        target.setStaLat(t.getStaLat());
        target.setMemo(t.getMemo());
        target.setTargetCalculation(t.getTargetCalculation());
        target.setTargetDataSourceMemo(t.getTargetDataSourceMemo());
        target.setSubjectId(t.getId());
        target.setSn(t.getSn());
        boolean result = this.subjectTargetManager.saveOrUpdate((Object)target);
        return result;
    }

    @Override
    public List<SysSubjectClass> getPatentTarget(String targetId) {
        Assert.hasText((String)targetId, (String)"\u8bf7\u9009\u62e9\u6307\u6807id");
        SysSubjectClass subjectClass = ((SysSubjectClassDao)this.baseMapper).getSubjectInfo(targetId);
        if (null == subjectClass) {
            return Lists.newArrayList();
        }
        String substring = subjectClass.getFullId().substring(0, subjectClass.getFullId().indexOf(subjectClass.getId(), 1) + targetId.length());
        String[] split = substring.split("/");
        List<SysSubjectClass> list = ((SysSubjectClassDao)this.baseMapper).findByTargetId(null, Arrays.asList(split));
        list.forEach(sysSubjectClass -> {
            if (!StringUtils.isEmpty((Object)sysSubjectClass.getTargetUnit()) && "\u6b27\u5143".equals(sysSubjectClass.getTargetUnit())) {
                sysSubjectClass.setTargetUnit("\u4e07\u6b27");
            }
        });
        return list;
    }
}

