/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cqlt.manager.impl;

import com.alibaba.fastjson.JSONObject;
import com.artfess.base.enums.DelStatusEnum;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.util.StringUtil;
import com.artfess.cqlt.dao.QfEnterpriseInfoDao;
import com.artfess.cqlt.dao.QfFinancePlDDao;
import com.artfess.cqlt.dao.QfFinancePlMDao;
import com.artfess.cqlt.manager.QfFinancePlDManager;
import com.artfess.cqlt.manager.QfFinancePlSManager;
import com.artfess.cqlt.manager.QfSubjectInternationalInfoManager;
import com.artfess.cqlt.model.QfEnterpriseInfo;
import com.artfess.cqlt.model.QfFinancePlD;
import com.artfess.cqlt.model.QfFinancePlM;
import com.artfess.cqlt.model.QfFinancePlS;
import com.artfess.cqlt.model.QfSubjectInternationalInfo;
import com.artfess.cqlt.vo.ReportDataVo;
import com.artfess.i18n.util.I18nUtil;
import com.artfess.poi.util.CustomHeader;
import com.artfess.poi.util.HeaderNode;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.google.api.client.util.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class QfFinancePlDManagerImpl
extends BaseManagerImpl<QfFinancePlDDao, QfFinancePlD>
implements QfFinancePlDManager {
    @Resource
    private QfFinancePlMDao financePlMDao;
    @Autowired
    private QfFinancePlSManager financePlSManager;
    @Resource
    private QfSubjectInternationalInfoManager subjectInternationalInfoManager;
    @Resource
    private QfEnterpriseInfoDao enterpriseInfoDao;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean batchUpdate(QfFinancePlM t) {
        Assert.hasText((String)t.getId(), (String)I18nUtil.getMessage((String)"QfOperationKpiM.reportId", (Locale)LocaleContextHolder.getLocale()));
        QfFinancePlM financePlM = (QfFinancePlM)((Object)this.financePlMDao.selectById((Serializable)((Object)t.getId())));
        ArrayList list = Lists.newArrayList();
        ArrayList totalList = Lists.newArrayList();
        Map<String, QfSubjectInternationalInfo> subjectMap = this.subjectInternationalInfoManager.getSubjectCodeMap("PL");
        QueryWrapper enterpriseInfoQuery = new QueryWrapper();
        enterpriseInfoQuery.eq((Object)"IS_DELE_", (Object)DelStatusEnum.N.getType());
        List enterpriseInfoList = this.enterpriseInfoDao.selectList((Wrapper)enterpriseInfoQuery);
        Map<String, QfEnterpriseInfo> enterpriseInfoMap = enterpriseInfoList.stream().collect(Collectors.toMap(item -> item.getCode(), item -> item));
        t.getList().forEach(detail -> {
            detail.setFillDate(financePlM.getFillDate());
            detail.setMainId(t.getId());
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"subject_code_", (Object)detail.getSubjectCode());
            queryWrapper.eq((Object)"main_id_", (Object)t.getId());
            queryWrapper.eq((Object)"enterprise_code_", (Object)detail.getEnterpriseCode());
            QfFinancePlD QfFinancePlD2 = (QfFinancePlD)((Object)((Object)((QfFinancePlDDao)this.baseMapper).selectOne((Wrapper)queryWrapper)));
            if (null != QfFinancePlD2) {
                QfFinancePlD2.setActualYtd(detail.getActualYtd());
                list.add(QfFinancePlD2);
            } else {
                QfSubjectInternationalInfo subjectInternationalInfo = (QfSubjectInternationalInfo)((Object)((Object)subjectMap.get(detail.getSubjectCode())));
                detail.setSubjectNameEn(subjectInternationalInfo.getNameEn());
                detail.setSubjectUnit(subjectInternationalInfo.getUnit());
                detail.setSubjectName(subjectInternationalInfo.getName());
                if (!StringUtils.isEmpty((Object)subjectInternationalInfo.getLevel())) {
                    detail.setSubjectLevel(Integer.parseInt(subjectInternationalInfo.getLevel()));
                }
                if (enterpriseInfoMap.containsKey(detail.getEnterpriseCode())) {
                    QfEnterpriseInfo qfEnterpriseInfo = (QfEnterpriseInfo)((Object)((Object)enterpriseInfoMap.get(detail.getEnterpriseCode())));
                    detail.setEnterpriseName(qfEnterpriseInfo.getName());
                    detail.setEnterpriseNameEn(qfEnterpriseInfo.getNameEn());
                }
                list.add(detail);
            }
        });
        t.getTotalList().forEach(detail -> {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"subject_code_", (Object)detail.getSubjectCode());
            queryWrapper.eq((Object)"main_id_", (Object)t.getId());
            QfFinancePlS financePlActualS = (QfFinancePlS)((Object)((Object)this.financePlSManager.getBaseMapper().selectOne((Wrapper)queryWrapper)));
            if (null != financePlActualS) {
                if (null != detail.getActualTotal()) {
                    financePlActualS.setActualTotal(detail.getActualTotal());
                }
                if (null != detail.getActualPosting()) {
                    financePlActualS.setActualPosting(detail.getActualPosting());
                }
                if (null != detail.getActualConsolidated()) {
                    financePlActualS.setActualConsolidated(detail.getActualConsolidated());
                }
                totalList.add(financePlActualS);
            } else {
                detail.setFillDate(financePlM.getFillDate());
                detail.setFillQuarter(financePlM.getFillQuarter());
                detail.setFillMonth(financePlM.getFillMonth());
                detail.setFillYear(financePlM.getFillYear());
                detail.setMainId(t.getId());
                QfSubjectInternationalInfo subjectInternationalInfo = (QfSubjectInternationalInfo)((Object)((Object)subjectMap.get(detail.getSubjectCode())));
                detail.setSubjectNameEn(subjectInternationalInfo.getNameEn());
                detail.setSubjectUnit(subjectInternationalInfo.getUnit());
                detail.setSubjectName(subjectInternationalInfo.getName());
                totalList.add(detail);
            }
        });
        if (!CollectionUtils.isEmpty((Collection)list)) {
            this.saveOrUpdateBatch(list);
        }
        if (!CollectionUtils.isEmpty((Collection)totalList)) {
            this.financePlSManager.saveOrUpdateBatch(totalList);
        }
        return true;
    }

    @Override
    public void export(HttpServletRequest request, HttpServletResponse response, List<QfFinancePlD> list, String sheetName) throws IOException {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        String mainId = list.get(0).getMainId();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"main_id_", (Object)mainId);
        List financePlSList = this.financePlSManager.getBaseMapper().selectList((Wrapper)queryWrapper);
        List<String> enterpriseCodeHeader = ((QfFinancePlDDao)this.baseMapper).getEnterpriseCodeHeader(mainId);
        List<String> subjectCodes = ((QfFinancePlDDao)this.baseMapper).getSubjectCodes(mainId);
        HashMap rowMap = Maps.newHashMap();
        AtomicReference<Integer> row = new AtomicReference<Integer>(0);
        subjectCodes.forEach(subjectCode -> {
            row.getAndSet((Integer)row.get() + 1);
            rowMap.put(subjectCode, row.get());
        });
        HashMap columMap = Maps.newHashMap();
        ArrayList headerNodeList = Lists.newArrayList();
        AtomicReference<Integer> column = new AtomicReference<Integer>(1);
        enterpriseCodeHeader.forEach(code -> {
            column.getAndSet((Integer)column.get() + 1);
            HeaderNode headerNode = new HeaderNode();
            headerNode.setRow(0);
            headerNode.setColumn(((Integer)column.get()).intValue());
            headerNode.setHeaderName(code);
            headerNodeList.add(headerNode);
            columMap.put(code, headerNode.getColumn());
        });
        HeaderNode headerNode = new HeaderNode();
        headerNode.setRow(0);
        headerNode.setColumn(0);
        headerNode.setHeaderName("subjectName");
        headerNodeList.add(headerNode);
        headerNode = new HeaderNode();
        headerNode.setRow(0);
        headerNode.setColumn(1);
        headerNode.setHeaderName("subjectCode");
        headerNodeList.add(headerNode);
        headerNode = new HeaderNode();
        headerNode.setRow(0);
        headerNode.setColumn(columMap.size() + 1);
        headerNode.setHeaderName("Total");
        headerNodeList.add(headerNode);
        headerNode = new HeaderNode();
        headerNode.setRow(0);
        headerNode.setColumn(columMap.size() + 2);
        headerNode.setHeaderName("Consolidation Posting");
        headerNodeList.add(headerNode);
        headerNode = new HeaderNode();
        headerNode.setRow(0);
        headerNode.setColumn(columMap.size() + 3);
        headerNode.setHeaderName("Consolidated Financial Statement");
        headerNodeList.add(headerNode);
        list.forEach(detail -> {
            HeaderNode node = new HeaderNode();
            node.setRow(((Integer)rowMap.get(detail.getSubjectCode())).intValue());
            node.setColumn(((Integer)columMap.get(detail.getEnterpriseCode())).intValue());
            node.setHeaderName(detail.getActualYtd() + "");
            headerNodeList.add(node);
            node = new HeaderNode();
            node.setRow(((Integer)rowMap.get(detail.getSubjectCode())).intValue());
            node.setColumn(0);
            String spaceStr = StringUtil.addSpace((Integer)detail.getSubjectLevel());
            node.setHeaderName(spaceStr + detail.getSubjectName());
            headerNodeList.add(node);
            node = new HeaderNode();
            node.setRow(((Integer)rowMap.get(detail.getSubjectCode())).intValue());
            node.setColumn(1);
            node.setHeaderName(detail.getSubjectCode());
            headerNodeList.add(node);
        });
        Integer maxColum = columMap.size();
        financePlSList.forEach(pls -> {
            HeaderNode node = new HeaderNode();
            if (null != pls.getActualConsolidated()) {
                node.setRow(((Integer)rowMap.get(pls.getSubjectCode())).intValue());
                node.setColumn(maxColum + 3);
                node.setHeaderName(pls.getActualConsolidated() + "");
                headerNodeList.add(node);
                node = new HeaderNode();
            }
            if (null != pls.getActualPosting()) {
                node.setRow(((Integer)rowMap.get(pls.getSubjectCode())).intValue());
                node.setColumn(maxColum + 2);
                node.setHeaderName(pls.getActualPosting() + "");
                headerNodeList.add(node);
            }
            if (null != pls.getActualTotal()) {
                node = new HeaderNode();
                node.setRow(((Integer)rowMap.get(pls.getSubjectCode())).intValue());
                node.setColumn(maxColum + 1);
                node.setHeaderName(pls.getActualTotal() + "");
                headerNodeList.add(node);
            }
        });
        String date = new SimpleDateFormat("yyyyMMddHHmmss").format(new Date());
        String fileName = String.format(sheetName + "-%s", date);
        CustomHeader.export((List)headerNodeList, (HttpServletResponse)response, (String)fileName, (String)sheetName);
    }

    @Override
    public List<ReportDataVo> getActualDataList(List<String> subjectCodes, Integer fillYear, Integer startMonth, Integer endMonth) {
        if (CollectionUtils.isEmpty(subjectCodes)) {
            return Lists.newArrayList();
        }
        return ((QfFinancePlDDao)this.baseMapper).getActualDataList(subjectCodes, fillYear, startMonth, endMonth);
    }

    @Override
    public List<JSONObject> detailQuery(List<QfFinancePlD> list) {
        if (CollectionUtils.isEmpty(list)) {
            return Lists.newArrayList();
        }
        String mainId = list.get(0).getMainId();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"main_id_", (Object)mainId);
        List financePlSList = this.financePlSManager.getBaseMapper().selectList((Wrapper)queryWrapper);
        List<String> enterpriseCodeHeader = ((QfFinancePlDDao)this.baseMapper).getEnterpriseCodeHeader(mainId);
        List<String> subjectCodes = ((QfFinancePlDDao)this.baseMapper).getSubjectCodes(mainId);
        ArrayList detailList = Lists.newArrayList();
        JSONObject detail = new JSONObject(true);
        detail.put("subjectName", (Object)"subjectName");
        detail.put("subjectCode", (Object)"subjectCode");
        detail.put("subjectUnit", (Object)"subjectUnit");
        detail.put("subjectLevel", (Object)"subjectLevel");
        enterpriseCodeHeader.forEach(code -> detail.put(code, code));
        detail.put("Total", (Object)"Total");
        detail.put("Consolidation Posting", (Object)"Consolidation Posting");
        detail.put("Consolidated Financial Statement", (Object)"Consolidated Financial Statement");
        detailList.add(detail);
        for (String subjectCode : subjectCodes) {
            JSONObject data = new JSONObject(true);
            data.put("subjectCode", (Object)subjectCode);
            for (QfFinancePlD pld : list) {
                if (!pld.getSubjectCode().equals(subjectCode)) continue;
                data.put("subjectName", (Object)pld.getSubjectName());
                data.put("subjectUnit", (Object)pld.getSubjectUnit());
                data.put("subjectLevel", (Object)pld.getSubjectLevel());
                data.put(pld.getEnterpriseCode(), (Object)pld.getActualYtd());
            }
            for (QfFinancePlS pls : financePlSList) {
                if (!pls.getSubjectCode().equals(subjectCode)) continue;
                data.put("Total", (Object)pls.getActualTotal());
                data.put("Consolidation Posting", (Object)pls.getActualPosting());
                data.put("Consolidated Financial Statement", (Object)pls.getActualConsolidated());
            }
            detailList.add(data);
        }
        return detailList;
    }
}

