# 创建索引

按表后缀和字段名生成创建索引的SQL语句<br>
执行下方SQL语句的查询结果即可

```SQL
-- 数据库名
SET @dbname = 'CQLT';
-- 表名后缀, 下划线转义
SET @suffix = '\_m';
-- 索引前缀
SET @index_prefix = 'index_';
-- 需要索引的字段, 以逗号分隔, 不能有空格
SET @index_fields = 'report_id_,fill_year_,fill_quarter_,fill_month_';

SELECT
	CONCAT( 'ALTER TABLE ', table_name, ' ADD INDEX ', @index_prefix, column_name, '(', column_name, ');' ) 
FROM
	information_schema.COLUMNS 
WHERE
	table_schema = @dbname 
	AND table_name LIKE CONCAT( '%', @suffix) 
	AND column_name IN (
	SELECT column_name
	FROM
		information_schema.COLUMNS 
	WHERE
		table_schema = @dbname 
	AND table_name LIKE CONCAT( '%', @suffix)
	AND FIND_IN_SET(column_name, @index_fields) >0);
```