/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cqlt.manager.impl;

import com.artfess.base.enums.DelStatusEnum;
import com.artfess.base.exception.BaseException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.cqlt.dao.QfOperationCipDDao;
import com.artfess.cqlt.dao.QfOperationCipMDao;
import com.artfess.cqlt.dao.QfSubjectInternationalInfoDao;
import com.artfess.cqlt.manager.QfOperationCipDManager;
import com.artfess.cqlt.model.QfOperationCipD;
import com.artfess.cqlt.model.QfOperationCipM;
import com.artfess.cqlt.model.QfSubjectInternationalInfo;
import com.artfess.i18n.util.I18nUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import java.io.Serializable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@Service
public class QfOperationCipDManagerImpl
extends BaseManagerImpl<QfOperationCipDDao, QfOperationCipD>
implements QfOperationCipDManager {
    @Resource
    private QfOperationCipMDao cipMDao;
    @Resource
    private QfSubjectInternationalInfoDao subjectInternationalInfoDao;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean batchSave(QfOperationCipM t) {
        Assert.hasText((String)t.getId(), (String)I18nUtil.getMessage((String)"QfOperationKpiM.reportId", (Locale)LocaleContextHolder.getLocale()));
        QfOperationCipM qfOperationCipM = (QfOperationCipM)((Object)this.cipMDao.selectById((Serializable)((Object)t.getId())));
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"IS_DELE_", (Object)DelStatusEnum.N.getType());
        List qfSubjectInternationalInfos = this.subjectInternationalInfoDao.selectList((Wrapper)query);
        Map<String, QfSubjectInternationalInfo> detailMap = qfSubjectInternationalInfos.stream().collect(Collectors.toMap(item -> item.getCode(), item -> item));
        List<QfOperationCipD> list = t.getList();
        StringBuffer sb = new StringBuffer();
        list.forEach(detail -> {
            detail.setMainId(t.getId());
            detail.setFillDate(qfOperationCipM.getFillDate());
            if (StringUtils.isEmpty((Object)detail.getSubjectCode())) {
                throw new BaseException(I18nUtil.getMessage((String)"fill.code", (Locale)LocaleContextHolder.getLocale()));
            }
            if (!detailMap.containsKey(detail.getSubjectCode())) {
                sb.append(",");
                sb.append(detail.getSubjectCode());
            } else {
                QfSubjectInternationalInfo subjectInternationalInfo = (QfSubjectInternationalInfo)((Object)((Object)detailMap.get(detail.getSubjectCode())));
                detail.setSubjectNameEn(subjectInternationalInfo.getNameEn());
                detail.setSubjectUnit(subjectInternationalInfo.getUnit());
                detail.setSubjectName(subjectInternationalInfo.getName());
                if (!StringUtils.isEmpty((Object)subjectInternationalInfo.getLevel())) {
                    detail.setSubjectLevel(Integer.parseInt(subjectInternationalInfo.getLevel()));
                }
            }
        });
        if (sb.length() > 0) {
            throw new BaseException(sb.substring(1) + I18nUtil.getMessage((String)"code.notExist", (Locale)LocaleContextHolder.getLocale()));
        }
        boolean b = this.saveBatch(list);
        return b;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean batchUpdate(QfOperationCipM t) {
        Assert.hasText((String)t.getId(), (String)I18nUtil.getMessage((String)"QfOperationKpiM.reportId", (Locale)LocaleContextHolder.getLocale()));
        QfOperationCipM qfOperationCipM = (QfOperationCipM)((Object)this.cipMDao.selectById((Serializable)((Object)t.getId())));
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"IS_DELE_", (Object)DelStatusEnum.N.getType());
        List qfSubjectInternationalInfos = this.subjectInternationalInfoDao.selectList((Wrapper)query);
        Map<String, QfSubjectInternationalInfo> detailMap = qfSubjectInternationalInfos.stream().collect(Collectors.toMap(item -> item.getCode(), item -> item));
        List<QfOperationCipD> list = t.getList();
        StringBuffer sb = new StringBuffer();
        list.forEach(detail -> {
            detail.setMainId(t.getId());
            detail.setFillDate(qfOperationCipM.getFillDate());
            if (StringUtils.isEmpty((Object)detail.getSubjectCode())) {
                throw new BaseException(I18nUtil.getMessage((String)"fill.code", (Locale)LocaleContextHolder.getLocale()));
            }
            if (!detailMap.containsKey(detail.getSubjectCode())) {
                sb.append(",");
                sb.append(detail.getSubjectCode());
            } else {
                QfSubjectInternationalInfo subjectInternationalInfo = (QfSubjectInternationalInfo)((Object)((Object)detailMap.get(detail.getSubjectCode())));
                detail.setSubjectNameEn(subjectInternationalInfo.getNameEn());
                detail.setSubjectUnit(subjectInternationalInfo.getUnit());
                detail.setSubjectName(subjectInternationalInfo.getName());
                if (!StringUtils.isEmpty((Object)subjectInternationalInfo.getLevel())) {
                    detail.setSubjectLevel(Integer.parseInt(subjectInternationalInfo.getLevel()));
                }
            }
        });
        if (sb.length() > 0) {
            throw new BaseException(sb.substring(1) + I18nUtil.getMessage((String)"code.notExist", (Locale)LocaleContextHolder.getLocale()));
        }
        boolean b = this.saveOrUpdateBatch(list);
        return b;
    }
}

