/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cqlt.manager.impl;

import com.artfess.base.exception.BaseException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.util.DateUtils;
import com.artfess.cqlt.dao.QfOperationMacrMDao;
import com.artfess.cqlt.manager.QfOperationMacrDManager;
import com.artfess.cqlt.manager.QfOperationMacrMManager;
import com.artfess.cqlt.manager.QfSubjectInternationalInfoManager;
import com.artfess.cqlt.model.QfOperationMacrD;
import com.artfess.cqlt.model.QfOperationMacrM;
import com.artfess.i18n.util.I18nUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class QfOperationMacrMManagerImpl
extends BaseManagerImpl<QfOperationMacrMDao, QfOperationMacrM>
implements QfOperationMacrMManager {
    @Autowired
    private QfOperationMacrDManager detailManager;
    @Autowired
    private QfSubjectInternationalInfoManager subjectInfoManager;

    private void processDetail(List<QfOperationMacrD> list, String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"main_id_", (Object)id);
        this.detailManager.remove((Wrapper)queryWrapper);
        list.forEach(detail -> detail.setMainId(id));
        this.detailManager.saveBatch(list);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean importExcel(List<QfOperationMacrD> list, String mainId) {
        QfOperationMacrM QfOperationMacrM2 = (QfOperationMacrM)((Object)((QfOperationMacrMDao)this.baseMapper).selectById((Serializable)((Object)mainId)));
        Assert.notNull((Object)((Object)QfOperationMacrM2), (String)I18nUtil.getMessage((String)"filldata.notExist", (Locale)LocaleContextHolder.getLocale()));
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"main_id_", (Object)mainId);
        this.detailManager.remove((Wrapper)queryWrapper);
        List subjectInfos = this.subjectInfoManager.list();
        list.forEach(detail -> {
            detail.setMainId(mainId);
            subjectInfos.forEach(si -> {
                if (detail.getSubjectCode().equals(si.getCode())) {
                    detail.setSubjectUnit(si.getUnit());
                    detail.setSubjectName(si.getName());
                    detail.setSubjectNameEn(si.getNameEn());
                    if (!StringUtils.isEmpty((Object)si.getLevel())) {
                        detail.setSubjectLevel(Integer.parseInt(si.getLevel()));
                    }
                    return;
                }
            });
        });
        boolean b = this.detailManager.saveBatch(list);
        return b;
    }

    @Override
    public boolean updateStatus(QfOperationMacrM t) {
        QfOperationMacrM QfOperationMacrM2 = (QfOperationMacrM)((Object)((QfOperationMacrMDao)this.baseMapper).selectById((Serializable)((Object)t.getId())));
        if (null == QfOperationMacrM2) {
            return false;
        }
        QfOperationMacrM2.setStatus(QfOperationMacrM2.getStatus() == 0 ? 1 : 0);
        int i = ((QfOperationMacrMDao)this.baseMapper).updateById((Object)QfOperationMacrM2);
        return i > 0;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean insertInfo(QfOperationMacrM t) {
        t.setFillQuarter(DateUtils.getQuarterByMonth((int)t.getFillMonth()));
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"fill_year_", (Object)t.getFillYear());
        queryWrapper.eq((Object)"fill_month_", (Object)t.getFillMonth());
        queryWrapper.eq((Object)"report_id_", (Object)t.getReportId());
        List QfOperationMacrMS = ((QfOperationMacrMDao)this.baseMapper).selectList((Wrapper)queryWrapper);
        if (!CollectionUtils.isEmpty((Collection)QfOperationMacrMS)) {
            throw new BaseException(I18nUtil.getMessage((String)"QfOperationKpiM.repeat", (Locale)LocaleContextHolder.getLocale()));
        }
        int insert = ((QfOperationMacrMDao)this.baseMapper).insert((Object)t);
        return insert > 0;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean updateInfo(QfOperationMacrM t) {
        t.setFillQuarter(DateUtils.getQuarterByMonth((int)t.getFillMonth()));
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"fill_year_", (Object)t.getFillYear());
        queryWrapper.eq((Object)"fill_month_", (Object)t.getFillMonth());
        queryWrapper.eq((Object)"report_id_", (Object)t.getReportId());
        queryWrapper.ne((Object)"id_", (Object)t.getId());
        List QfOperationMacrMS = ((QfOperationMacrMDao)this.baseMapper).selectList((Wrapper)queryWrapper);
        if (!CollectionUtils.isEmpty((Collection)QfOperationMacrMS)) {
            throw new BaseException(I18nUtil.getMessage((String)"QfOperationKpiM.repeat", (Locale)LocaleContextHolder.getLocale()));
        }
        int insert = ((QfOperationMacrMDao)this.baseMapper).updateById((Object)t);
        return insert > 0;
    }
}

