/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cqlt.manager.impl;

import com.artfess.base.enums.DelStatusEnum;
import com.artfess.base.exception.BaseException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.cqlt.dao.QfOperationCipMDao;
import com.artfess.cqlt.dao.QfSubjectInternationalInfoDao;
import com.artfess.cqlt.manager.QfOperationCipDManager;
import com.artfess.cqlt.manager.QfOperationCipMManager;
import com.artfess.cqlt.model.QfOperationCipD;
import com.artfess.cqlt.model.QfOperationCipM;
import com.artfess.cqlt.model.QfSubjectInternationalInfo;
import com.artfess.i18n.util.I18nUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class QfOperationCipMManagerImpl
extends BaseManagerImpl<QfOperationCipMDao, QfOperationCipM>
implements QfOperationCipMManager {
    @Autowired
    private QfOperationCipDManager operationCipDManager;
    @Resource
    private QfSubjectInternationalInfoDao subjectInternationalInfoDao;

    private void processDetail(List<QfOperationCipD> list, String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"main_id_", (Object)id);
        this.operationCipDManager.remove((Wrapper)queryWrapper);
        list.forEach(detail -> detail.setMainId(id));
        this.operationCipDManager.saveBatch(list);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean importExcel(List<QfOperationCipD> list, String mainId) {
        QfOperationCipM cipM = (QfOperationCipM)((Object)((QfOperationCipMDao)this.baseMapper).selectById((Serializable)((Object)mainId)));
        Assert.notNull((Object)((Object)cipM), (String)I18nUtil.getMessage((String)"filldata.notExist", (Locale)LocaleContextHolder.getLocale()));
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"IS_DELE_", (Object)DelStatusEnum.N.getType());
        List qfSubjectInternationalInfos = this.subjectInternationalInfoDao.selectList((Wrapper)query);
        Map<String, QfSubjectInternationalInfo> detailMap = qfSubjectInternationalInfos.stream().collect(Collectors.toMap(item -> item.getCode(), item -> item));
        StringBuffer sb = new StringBuffer();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"main_id_", (Object)mainId);
        this.operationCipDManager.remove((Wrapper)queryWrapper);
        list.forEach(detail -> {
            detail.setMainId(mainId);
            detail.setFillDate(cipM.getFillDate());
            if (StringUtils.isEmpty((Object)detail.getSubjectCode())) {
                throw new BaseException(I18nUtil.getMessage((String)"fill.code", (Locale)LocaleContextHolder.getLocale()));
            }
            if (!detailMap.containsKey(detail.getSubjectCode())) {
                sb.append(",");
                sb.append(detail.getSubjectCode());
            } else {
                QfSubjectInternationalInfo subjectInternationalInfo = (QfSubjectInternationalInfo)((Object)((Object)detailMap.get(detail.getSubjectCode())));
                detail.setSubjectNameEn(subjectInternationalInfo.getNameEn());
                detail.setSubjectUnit(subjectInternationalInfo.getUnit());
                detail.setSubjectName(subjectInternationalInfo.getName());
                if (!StringUtils.isEmpty((Object)subjectInternationalInfo.getLevel())) {
                    detail.setSubjectLevel(Integer.parseInt(subjectInternationalInfo.getLevel()));
                }
            }
        });
        if (sb.length() > 0) {
            throw new BaseException(sb.substring(1) + I18nUtil.getMessage((String)"code.notExist", (Locale)LocaleContextHolder.getLocale()));
        }
        boolean b = this.operationCipDManager.saveBatch(list);
        return b;
    }

    @Override
    public boolean updateStatus(QfOperationCipM t) {
        QfOperationCipM cipM = (QfOperationCipM)((Object)((QfOperationCipMDao)this.baseMapper).selectById((Serializable)((Object)t.getId())));
        if (null == cipM) {
            return false;
        }
        cipM.setStatus(cipM.getStatus() == 0 ? 1 : 0);
        int i = ((QfOperationCipMDao)this.baseMapper).updateById((Object)cipM);
        return i > 0;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean insertInfo(QfOperationCipM t) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"fill_year_", (Object)t.getFillYear());
        queryWrapper.eq((Object)"fill_month_", (Object)t.getFillMonth());
        queryWrapper.eq((Object)"report_id_", (Object)t.getReportId());
        List operationCipMS = ((QfOperationCipMDao)this.baseMapper).selectList((Wrapper)queryWrapper);
        if (!CollectionUtils.isEmpty((Collection)operationCipMS)) {
            throw new BaseException(I18nUtil.getMessage((String)"QfOperationKpiM.repeat", (Locale)LocaleContextHolder.getLocale()));
        }
        int insert = ((QfOperationCipMDao)this.baseMapper).insert((Object)t);
        return insert > 0;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean updateInfo(QfOperationCipM t) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"fill_year_", (Object)t.getFillYear());
        queryWrapper.eq((Object)"fill_month_", (Object)t.getFillMonth());
        queryWrapper.eq((Object)"report_id_", (Object)t.getReportId());
        queryWrapper.ne((Object)"id_", (Object)t.getId());
        List operationCipMS = ((QfOperationCipMDao)this.baseMapper).selectList((Wrapper)queryWrapper);
        if (!CollectionUtils.isEmpty((Collection)operationCipMS)) {
            throw new BaseException(I18nUtil.getMessage((String)"QfOperationKpiM.repeat", (Locale)LocaleContextHolder.getLocale()));
        }
        int insert = ((QfOperationCipMDao)this.baseMapper).updateById((Object)t);
        return insert > 0;
    }
}

