/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.base.util;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class CollectionUtils {
    public static boolean isNotEmpty(Collection<?> collection) {
        return null != collection && collection.size() > 0;
    }

    public static boolean isEmpty(Collection<?> collection) {
        return !CollectionUtils.isNotEmpty(collection);
    }

    public static boolean isNotEmpty(Map map) {
        return null != map && map.size() > 0;
    }

    public static boolean isEmpty(Map map) {
        return !CollectionUtils.isNotEmpty(map);
    }

    public static <T> boolean isNotEmpty(T[] ts) {
        return null != ts && ts.length > 0;
    }

    public static <T> boolean isEmpty(T[] ts) {
        return !CollectionUtils.isNotEmpty(ts);
    }

    public static <T> List<T> arrayToList(T[] ts) {
        ArrayList<T> list = new ArrayList<T>();
        if (null != ts && ts.length > 0) {
            for (T t : ts) {
                list.add(t);
            }
        }
        return list;
    }

    public static <T> List<T> rand(List<T> list, int row) {
        if (CollectionUtils.isEmpty(list) || list.size() < row) {
            return list;
        }
        HashSet<T> nlist = new HashSet<T>();
        Random random = new Random();
        while (nlist.size() < row) {
            nlist.add(list.get(random.nextInt(list.size())));
        }
        return new ArrayList(nlist);
    }

    public static int size(Collection collection) {
        if (CollectionUtils.isNotEmpty(collection)) {
            return collection.size();
        }
        return 0;
    }

    public static int size(Map map) {
        if (CollectionUtils.isNotEmpty(map)) {
            return map.size();
        }
        return 0;
    }

    public static <T> int length(T[] ts) {
        if (CollectionUtils.isNotEmpty(ts)) {
            return ts.length;
        }
        return 0;
    }

    public static int[] average(int sum, int count) {
        int i;
        if (count < 1) {
            return new int[0];
        }
        int[] ints = new int[count];
        int d1 = sum / count;
        int d2 = sum % count;
        for (i = 0; i < ints.length; ++i) {
            ints[i] = 0 + d1;
        }
        for (i = 0; i < d2; ++i) {
            ints[i] = ints[i] + 1;
        }
        return ints;
    }

    public static <T> T getIndex(List<T> list, int index) {
        if (CollectionUtils.isEmpty(list) || index < 0 || CollectionUtils.size(list) <= index - 1) {
            return null;
        }
        return list.get(index);
    }

    public static <T> T getIndex(T[] sources, int index) {
        if (CollectionUtils.isEmpty(sources) || index < 0 || CollectionUtils.length(sources) <= index - 1) {
            return null;
        }
        return sources[index];
    }

    public static <T> Set<T> arrayToSet(T[] sources) {
        HashSet<T> set = new HashSet<T>();
        if (CollectionUtils.isEmpty(sources)) {
            return set;
        }
        for (T t : sources) {
            set.add(t);
        }
        return set;
    }

    public static <T> boolean equalsRepeat(T[] sources) {
        return CollectionUtils.equalsRepeat(CollectionUtils.arrayToList(sources));
    }

    public static <T> boolean equalsRepeat(List<T> sourceList) {
        HashSet<T> set = new HashSet<T>();
        for (T t : sourceList) {
            if (set.contains(t)) {
                return true;
            }
            set.add(t);
        }
        return false;
    }

    public static <T> List<T> init(List<T> list) {
        if (null == list) {
            return new ArrayList();
        }
        return list;
    }

    public static <T> T getOne(Collection<T> collection) {
        if (CollectionUtils.isNotEmpty(collection)) {
            return collection.iterator().next();
        }
        return null;
    }

    public static <T> ArrayList<T>[] averaging(int thread, List<T> list) {
        ArrayList[] zoneArrows = new ArrayList[thread];
        if (CollectionUtils.isEmpty(list)) {
            return zoneArrows;
        }
        for (int i = 0; i < list.size(); ++i) {
            int in_size = i % thread;
            ArrayList<T> li = zoneArrows[in_size];
            if (null == li) {
                li = new ArrayList<T>();
            }
            li.add(list.get(i));
            zoneArrows[in_size] = li;
        }
        return zoneArrows;
    }

    public static void main(String[] args) {
        String[] ids = new String[]{"", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""};
        System.out.println(ids.length);
        int index = ids.length;
        for (int i = 1; i < ids.length; ++i) {
            String[] ids2 = new String[i];
            for (int j = 0; j < i; ++j) {
                ids2[j] = ids[j];
            }
            for (int k = 0; k < ids.length; ++k) {
                String str = "i=" + i + "_k=" + k + ">";
                String str2 = null;
                try {
                    str2 = CollectionUtils.getIndex(ids2, k);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                str = null == str2 ? str + "\u5931\u8d25" : str + "\u6210\u529f";
                System.out.println(str);
            }
        }
    }

    public static JSONObject getHeaders(HttpServletRequest request) {
        JSONObject hearJson = new JSONObject();
        if (null == request) {
            return hearJson;
        }
        HashMap map = Maps.newHashMap();
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String key = (String)headerNames.nextElement();
            hearJson.put(key, (Object)request.getHeader(key));
            map.put(key, request.getHeader(key));
        }
        return hearJson;
    }
}

