package com.artfess.manage.safty.manager.dto;

import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONUtil;
import com.artfess.base.entity.AutoFillModel;
import com.artfess.manage.safty.model.CmgtSaftyDangerUnit;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.time.LocalDate;
import java.time.LocalDateTime;


/**
 * cmgt_safty_danger_checkrecord
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wujl
 * @since 2022-08-01
 */
@Data
@ApiModel(value="CmgtSaftyDangerCheckrecordDto", description="安全隐患排查记录DTO对象")
public class CmgtSaftyDangerCheckrecordDto extends AutoFillModel<CmgtSaftyDangerCheckrecordDto> {

    /** 主键_ID */
    @ApiModelProperty(value = "主键_ID")
    private String id;


    /** 排查计划ID */
    @ApiModelProperty(value = "排查计划ID")
    private String checkplanId;


    /** 隐患类型 */
    @ApiModelProperty(value = "隐患类型")
    private String dangerType;


    /** 是否重大隐患 */
    @ApiModelProperty(value = "是否重大隐患")
    private String imark;


    /** 排查时间 */
    @ApiModelProperty(value = "排查时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd",timezone="GMT+8")
    private LocalDate checkDate;


    /** 检查人 */
    @ApiModelProperty(value = "检查人")
    private String checkUser;


    /** 检查内容 */
    @ApiModelProperty(value = "检查内容")
    private String content;


    /** 检查对象 */
    @ApiModelProperty(value = "检查对象")
    private String recipient;

    private CmgtSaftyDangerUnit cmgtSaftyDangerUnit;


    /** 检查地点 */
    @ApiModelProperty(value = "检查地点")
    private String location;


    /** 检查结果 */
    @ApiModelProperty(value = "检查结果")
    private String result;


    /** 隐患内容 */
    @ApiModelProperty(value = "隐患内容")
    private String danger;


    /** 隐患排查方案 */
    @ApiModelProperty(value = "隐患排查方案")
    private String pcfa;


    /** 隐患复查人 */
    @ApiModelProperty(value = "隐患复查人")
    private String reviewer;


    /** 复查时间 */
    @ApiModelProperty(value = "复查时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd",timezone="GMT+8")
    private LocalDate reviewDate;


    /** 复查结果 */
    @ApiModelProperty(value = "复查结果")
    private String reviewResult;


    /** 遗留问题 */
    @ApiModelProperty(value = "遗留问题")
    private String remainingProblem;


    /** 整改期限 */
    @ApiModelProperty(value = "整改期限")
    private String timeLimit;


    /** 隐患处理负责人 */
    @ApiModelProperty(value = "隐患处理负责人")
    private String resolver;


    /** 负责机构 */
    @ApiModelProperty(value = "负责机构")
    private String resolvingOrg;


    /** 隐患处理措施 */
    @ApiModelProperty(value = "隐患处理措施")
    private String resolvingMeasure;


    /** 隐患处理情况 */
    @ApiModelProperty(value = "隐患处理情况")
    private String resolvingRemark;


    /** 隐患处理时间 */
    @ApiModelProperty(value = "隐患处理时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd",timezone="GMT+8")
    private LocalDate resolvingDate;


    /** 状态 */
    @ApiModelProperty(value = "状态")
    private String status;


    /** 排序 */
    @ApiModelProperty(value = "排序")
    private Integer sn;


    /** 备注 */
    @ApiModelProperty(value = "备注")
    private String memo;


    /** 删除标识，1已删除，0未删除 */
    @ApiModelProperty(value = "删除标识，1已删除，0未删除")
    private String isDele;


    /** 版本号 */
    @ApiModelProperty(value = "版本号")
    private Integer version;


    /** 数据时间戳 */
    @ApiModelProperty(value = "数据时间戳")
    private LocalDateTime lastTime;

    /** 排查时附件 */
    @ApiModelProperty(value = "排查时附件列表")
    private String baseInfoFiles;

    /** 复查时附件 */
    @ApiModelProperty(value = "复查时附件列表")
    private String fcFiles;

    public JSONArray getBaseInfoFileList() {
        if(this.baseInfoFiles!=null){
            return JSONUtil.parseArray(this.baseInfoFiles);
        }else{
            return  JSONUtil.createArray();
        }
    }

    public void setBaseInfoFileList(JSONArray o) {
        if (o != null) {
            this.baseInfoFiles = JSONUtil.parse(o).toStringPretty();
        } else {
            this.baseInfoFiles = null;
        }
    }

    public JSONArray getFcFileList() {
        if(this.fcFiles!=null){
            return JSONUtil.parseArray(this.fcFiles);
        }else{
            return  JSONUtil.createArray();
        }
    }

    public void setFcFileList(JSONArray o) {
        if (o != null) {
            this.fcFiles= JSONUtil.parse(o).toStringPretty();
        } else {
            this.fcFiles= null;
        }
    }
}
