package com.artfess.manage.duty.model;

import com.artfess.base.entity.AutoFillModel;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.FieldRepeat;
import com.artfess.base.valid.UpdateGroup;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableLogic;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Null;
import java.time.LocalDateTime;

/**
 * 勤务小组信息
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wjl
 * @since 2022-07-20
 */
@Data
@ApiModel(value="CmgtDutyTeam对象", description="勤务小组信息")
@FieldRepeat(fields = {"code"},message = "小组编号不能重复，请重新输入",groups = {AddGroup.class, UpdateGroup.class})
public class CmgtDutyTeam extends AutoFillModel<CmgtDutyTeam> {

    private static final long serialVersionUID = 1L;

    @NotNull(message = "修改必须指定id",groups = {UpdateGroup.class})
    @Null(message = "新增不能指定id",groups = {AddGroup.class})
    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @NotBlank(message = "编号",groups = {AddGroup.class,UpdateGroup.class})
    @ApiModelProperty(value = "编号")
    @TableField("CODE_")
    private String code;

    @NotBlank(message = "编号",groups = {AddGroup.class,UpdateGroup.class})
    @ApiModelProperty(value = "名称")
    @TableField("NAME_")
    private String name;

    @ApiModelProperty(value = "组别名")
    @TableField("ALIAS_")
    private String alias;


    @ApiModelProperty(value = "组长")
    @TableField("HEADMAN_")
    private String headman;

    @ApiModelProperty(value = "负责区域")
    @TableField("AREA_")
    private String area;

    @ApiModelProperty(value = "排序")
    @TableField("SN_")
    private Integer sn;

    @ApiModelProperty(value = "备注")
    @TableField("MEMO_")
    private String memo;

    /** 归属部门 */
    @ApiModelProperty(value = "归属部门")
    @TableField("org_id_")
    private String orgId;

    /** 归属部门 */
    @ApiModelProperty(value = "归属部门")
    @TableField("org_name_")
    private String orgName;

    @TableLogic
    @ApiModelProperty(value = "删除标识，1已删除，0未删除")
    @TableField("IS_DELE_")
    private String isDele;

//    @ApiModelProperty(value = "创建人")
//    @TableField("CREATE_BY_")
//    private String createBy;
//
//    @ApiModelProperty(value = "创建时间")
//    @TableField("CREATE_TIME_")
//    private LocalDateTime createTime;
//
//    @ApiModelProperty(value = "修改人员")
//    @TableField("UPDATE_BY_")
//    private String updateBy;
//
//    @ApiModelProperty(value = "修改时间")
//    @TableField("UPDATE_TIME_")
//    private LocalDateTime updateTime;

    @ApiModelProperty(value = "版本号")
    @TableField("VERSION_")
    private Integer version;

    @ApiModelProperty(value = "数据时间戳")
    @TableField("LAST_TIME_")
    private LocalDateTime lastTime;
}
