package com.artfess.manage.duty.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.manage.duty.dao.CmgtDutyJobDao;
import com.artfess.manage.duty.dao.CmgtDutyTeamDao;
import com.artfess.manage.duty.dao.CmgtDutyTeamMemberDao;
import com.artfess.manage.duty.manager.CmgtDutyTeamMemberManager;
import com.artfess.manage.duty.manager.dto.CmgtDutyTeamMemberDto;
import com.artfess.manage.duty.manager.mapper.CmgtDutyTeamMemberDtoMapper;
import com.artfess.manage.duty.model.CmgtDutyJob;
import com.artfess.manage.duty.model.CmgtDutyTeam;
import com.artfess.manage.duty.model.CmgtDutyTeamMember;
import com.artfess.uc.dao.OrgDao;
import com.artfess.uc.model.Org;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 勤务队员信息 服务实现类
 *
 * @author 超级管理员
 * @company 阿特菲斯信息技术有限公司
 * @since 2022-07-20
 */
@Service
public class CmgtDutyTeamMemberManagerImpl extends BaseManagerImpl<CmgtDutyTeamMemberDao, CmgtDutyTeamMember> implements CmgtDutyTeamMemberManager {

    @Resource
    CmgtDutyTeamMemberDao teamMemberDao;

    @Resource
    CmgtDutyTeamDao cmgtDutyTeamDao;

    @Resource
    CmgtDutyJobDao cmgtDutyJobDao;

    @Resource
    OrgDao orgDao;

    @Resource
    CmgtDutyTeamMemberDtoMapper cmgtDutyTeamMemberDtoMapper;


    @Override
    public PageList<CmgtDutyTeamMemberDto> pageQuery(QueryFilter<CmgtDutyTeamMember> queryFilter) {
        PageList<CmgtDutyTeamMember> result = query(queryFilter);
        PageList<CmgtDutyTeamMemberDto> r = new PageList<CmgtDutyTeamMemberDto>(
                result.getRows().stream().map(e -> {
                            CmgtDutyTeamMemberDto t = cmgtDutyTeamMemberDtoMapper.toDto(e);
                            if (t.getTeamId() != null) {
                                t.setCmgtDutyTeam(cmgtDutyTeamDao.selectById(t.getTeamId()));
                            } else {
                                t.setCmgtDutyTeam(new CmgtDutyTeam());
                            }
                            if (t.getOrgId() != null) {
                                t.setOrg(orgDao.selectById(t.getOrgId()));
                            } else {
                                t.setOrg(new Org());
                            }

                            if (t.getJob() != null) {
                                t.setCmgtDutyJob(cmgtDutyJobDao.selectById(t.getJob()));
                            } else {
                                t.setCmgtDutyJob(new CmgtDutyJob());
                            }

                            return t;
                        }
                ).collect(Collectors.toList())
        );
        r.setTotal(result.getTotal());
        r.setPage(result.getPage());
        r.setPageSize(result.getPageSize());
        return r;
    }

    @Override
    public List<Map<String, Object>> findAllMembersByTeamId(String teamid) {
        return teamMemberDao.findAllMembersByTeamId(teamid);
    }


    @Override
    public List<Map<String, Object>> findMembersUngroupedByOrgId(String orgId) {
        return teamMemberDao.findMembersUngroupedByOrgId(orgId);
    }


    @Override
    public String createInfo(CmgtDutyTeamMember t) {
        int i = this.baseMapper.insert(t);
        if (i > 0) {
            return t.getId();
        }
        return null;
    }

    @Override
    public String updateInfo(CmgtDutyTeamMember t) {
        this.baseMapper.updateById(t);
        return t.getId();
    }

    @Override
    public void deleteInfo(CmgtDutyTeamMember t) {
        this.baseMapper.deleteById(t.getId());
    }

    @Transactional
    public String create(CmgtDutyTeamMemberDto dto) {
        CmgtDutyTeamMember t = cmgtDutyTeamMemberDtoMapper.toEntity(dto);
        int i = this.baseMapper.insert(t);
        if (i > 0) {
            return t.getId();
        }
        return null;
    }

    @Transactional
    public String update(CmgtDutyTeamMemberDto dto) {
        CmgtDutyTeamMember t = cmgtDutyTeamMemberDtoMapper.toEntity(dto);
        this.baseMapper.updateById(t);


        return t.getId();
    }

    @Transactional
    public boolean delete(List<String> ids) {
        for (String id : ids) {

            int count = this.baseMapper.deleteById(id);
            if (count == 0) {
                return false;
            }
        }
        return true;
    }


}
