package com.artfess.manage.safty.model;


import com.artfess.base.entity.AutoFillModel;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.UpdateGroup;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Null;
import java.time.LocalDateTime;

/**
 * 安全目标考核项定义表(CmgtSaftyTargetCheck)表实体类
 *
 * @author 黎沐华
 * @since 2023-05-04 13:43:25
 */
@Data
@TableName("CMGT_SAFTY_TARGET_CHECK")
@ApiModel("安全目标考核项定义表(CmgtSaftyTargetCheck)表实体类")
public class CmgtSaftyTargetCheck extends AutoFillModel<CmgtSaftyTargetCheck> {

    @NotNull(message = "修改必须指定id", groups = {UpdateGroup.class})
    @Null(message = "新增不能指定id", groups = {AddGroup.class})
    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty("年度目标_ID")
    @TableField("target_year_")
    private String targetId;

    @ApiModelProperty("考核指标项名称")
    @TableField("kpi_name_")
    private String kpiName;

    @ApiModelProperty("考核指标项标准说明")
    @TableField("kpi_standard_")
    private String kpiStandard;

    @ApiModelProperty("指标考核方式（1：量化指标考核 2：主观指标考核）")
    @TableField("check_type_")
    private String checkType;

    @ApiModelProperty("指标考核得分范围值（1-10分）")
    @TableField("check_score_")
    private Integer checkScore;

    @ApiModelProperty("指标考核权重值（1-10）值越大权重越高")
    @TableField("check_weight_")
    private Integer checkWeight;

    @ApiModelProperty("排序")
    @TableField("sn_")
    private Integer sn;

    @ApiModelProperty(value = "删除标识，1已删除，0未删除")
    @TableField("is_dele_")
    private String isDele;

    @ApiModelProperty(value = "版本号")
    @TableField("version_")
    private Integer version;

    @ApiModelProperty(value = "数据时间戳")
    @TableField("last_time_")
    private LocalDateTime lastTime;

}

