package com.artfess.manage.safty.manager.dto;

import com.artfess.base.entity.AutoFillModel;
import com.artfess.manage.safty.model.CmgtSaftyDangerUnit;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.time.LocalDate;
import java.time.LocalDateTime;


/**
 * cmgt_safty_danger_checkplan
 *
 * @author wujl
 * @company 阿特菲斯信息技术有限公司
 * @since 2022-08-01
 */
@Data
@ApiModel(value = "CmgtSaftyDangerCheckplanDto", description = "安全隐患排查计划DTO对象")
public class CmgtSaftyDangerCheckplanDto extends AutoFillModel<CmgtSaftyDangerCheckplanDto> {

    /**
     * 主键_ID
     */
    @ApiModelProperty(value = "主键_ID")
    private String id;


    /**
     * 隐患类型
     */
    @ApiModelProperty(value = "隐患类型")
    private String dangerType;


    /**
     * 排查时间
     */
    @ApiModelProperty(value = "排查时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private LocalDate checkDate;


    /**
     * 检查人
     */
    @ApiModelProperty(value = "检查人")
    private String checkUser;


    /**
     * 检查内容
     */
    @ApiModelProperty(value = "检查内容")
    private String content;


    /**
     * 检查对象
     */
    @ApiModelProperty(value = "检查对象")
    private String recipient;

    private CmgtSaftyDangerUnit cmgtSaftyDangerUnit;

    /**
     * 排查方案
     */
    @ApiModelProperty(value = "排查方案")
    private String pcfa;


    /**
     * 排序
     */
    @ApiModelProperty(value = "排序")
    private Integer sn;


    /**
     * 备注
     */
    @ApiModelProperty(value = "备注")
    private String memo;


    /**
     * 删除标识，1已删除，0未删除
     */
    @ApiModelProperty(value = "删除标识，1已删除，0未删除")
    private String isDele;


    /**
     * 版本号
     */
    @ApiModelProperty(value = "版本号")
    private Integer version;


    /**
     * 数据时间戳
     */
    @ApiModelProperty(value = "数据时间戳")
    private LocalDateTime lastTime;


}
