package com.artfess.manage.safty.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.model.CommonResult;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.UpdateGroup;
import com.artfess.manage.safty.manager.CmgtSaftyCheckManager;
import com.artfess.manage.safty.model.CmgtSaftyCheck;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;

/**
 * 安全目标考核评分(CmgtSaftyCheck)表控制层
 *
 * @author 黎沐华
 * @since 2023-05-05 09:23:15
 */
@Slf4j
@RestController
@Api(tags = "安全目标考核评分")
@RequestMapping("/manager/cmgtSaftyCheck")
@ApiGroup(group = {ApiGroupConsts.MANAGER_BIZ})
public class CmgtSaftyCheckController extends BaseController<CmgtSaftyCheckManager, CmgtSaftyCheck> {

    @Override
    @PostMapping("/create")
    @ApiOperation("添加实体的接口")
    public CommonResult<String> create(@ApiParam(name = "model", value = "实体信息") @RequestBody @Validated({AddGroup.class}) CmgtSaftyCheck t) {
        boolean result =  baseService.save(t);
        if (!result) {
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION, "创建实体失败");
        }
        return new CommonResult<>(t.getId());
    }


    @Override
    @PutMapping("/updateById")
    @ApiOperation("更新实体的接口")
    public CommonResult<String> updateById(@ApiParam(name = "model", value = "实体信息") @RequestBody @Validated({UpdateGroup.class}) CmgtSaftyCheck t) {

        boolean result =  baseService.updateById(t);
        if (!result) {
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION, "更新实体失败");
        }
        return new CommonResult<>(t.getId());
    }


    @Override
    @DeleteMapping("/delete")
    @ApiOperation("根据id集合批量删除")
    public CommonResult<String> deleteByIds(@ApiParam(name = "ids", value = "实体集合") @RequestParam String... ids) {
        boolean result =  baseService.removeByIds(Arrays.asList(ids));
        if (!result) {
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION, "删除实体失败");
        }
        return new CommonResult<>();
    }

}

