package com.artfess.manage.material.manager.impl;


import cn.hutool.json.JSONUtil;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.manage.material.dao.CmgtMaterialQuantityDao;
import com.artfess.manage.material.dao.CmgtMaterialWarehouseInoutDao;
import com.artfess.manage.material.dao.CmgtMaterialWarehouseInoutDetailDao;
import com.artfess.manage.material.manager.CmgtMaterialInfoManager;
import com.artfess.manage.material.manager.CmgtMaterialQuantityManage;
import com.artfess.manage.material.manager.CmgtMaterialWarehouseInoutDetailManager;
import com.artfess.manage.material.manager.CmgtMaterialWarehouseInoutManager;
import com.artfess.manage.material.model.CmgtMaterialInfo;
import com.artfess.manage.material.model.CmgtMaterialQuantity;
import com.artfess.manage.material.model.CmgtMaterialWarehouseInout;
import com.artfess.manage.material.model.CmgtMaterialWarehouseInoutDetail;
import com.artfess.sysConfig.persistence.manager.SysIdentityManager;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.exception.BadRequestException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 物资出入库单 服务实现类
 *
 * @author wujl
 * @company 阿特菲斯信息技术有限公司
 * @since 2022-07-25
 */
@Service
public class CmgtMaterialWarehouseInoutManagerImpl extends BaseManagerImpl<CmgtMaterialWarehouseInoutDao, CmgtMaterialWarehouseInout> implements CmgtMaterialWarehouseInoutManager {

    @Resource
    private CmgtMaterialQuantityManage quantityManage;

    @Resource
    private CmgtMaterialQuantityDao quantityDao;

    @Resource
    private CmgtMaterialInfoManager materialInfoManager;


    @Resource
    private CmgtMaterialWarehouseInoutDetailManager warehouseInoutDetailManager;

    @Resource
    private CmgtMaterialWarehouseInoutDao warehouseInoutDao;

    @Resource
    private CmgtMaterialWarehouseInoutDetailDao cmgtMaterialWarehouseInoutDetailDao;


    @Resource
    SysIdentityManager sysIdentityManager;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Boolean createInout(CmgtMaterialWarehouseInout t) {
        t.getDetailList().forEach(d -> {
            d.setWarehouse(t.getWarehouse());
            d.setOrgId(t.getOrgId());
            d.setApplicant(t.getApplicant());
            d.setInoutDate(t.getInoutDate());
            d.setSupplier(t.getSource());
            d.setStatus(t.getStatus());
        });
        boolean result = false;
        if ("0".equals(t.getDataType())) { //新增物资入库单
            result = save(t);
            List<CmgtMaterialWarehouseInoutDetail> dlist = new ArrayList();
            t.getDetailList().forEach(d -> {
                //物资设置入库ID
                d.setWarehouseInoutId(t.getId());
                dlist.add(d);
            });
            //批量保存明细
            warehouseInoutDetailManager.saveBatch(dlist);
            if ("COMPLETED".equals(t.getStatus())) {
                this.addQuantity(dlist, t.getWarehouse());
            }
            return result;
        }
        if ("1".equals(t.getDataType())) { //新增物资出库单
            result = save(t);
            List<CmgtMaterialWarehouseInoutDetail> dlist = new ArrayList();
            t.getDetailList().forEach(d -> {
                //物资设置出库ID
                d.setWarehouseInoutId(t.getId());
                dlist.add(d);
            });
            //批量保存明细
            warehouseInoutDetailManager.saveBatch(dlist);
            //修改库存值，出库
            if ("COMPLETED".equals(t.getStatus())) {
                this.commitCK(dlist);
            }
            return result;
        }
        return result;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Boolean updateInout(CmgtMaterialWarehouseInout t) {
        t.getDetailList().forEach(d -> {
            d.setWarehouse(t.getWarehouse());
            d.setOrgId(t.getOrgId());
            d.setApplicant(t.getApplicant());
            d.setApplicantId(t.getApplicantId());
            d.setInoutDate(t.getInoutDate());
            d.setStatus(t.getStatus());
        });

        boolean res = false;
        if (t.getDataType().equals("0")) {//修改入库单
            res = updateById(t);
            //还原库存
            //res = subtractQuantity(t.getId(), t.getWarehouse());
            //删除明细
            this.delteDetail(t.getId());
            //保存新明细
            List<CmgtMaterialWarehouseInoutDetail> dlist = new ArrayList();
            t.getDetailList().forEach(d -> {
                d.setWarehouseInoutId(t.getId());
                d.setId(null);
                dlist.add(d);
            });
            //保存明细
            warehouseInoutDetailManager.saveBatch(dlist);
            //修改库存值，加入库存
            if ("COMPLETED".equals(t.getStatus())) {
                addQuantity(t.getDetailList(), t.getWarehouse());
            }
            return res;
        }
        if (t.getDataType().equals("1")) {//修改出库单
            res = updateById(t);
            //res = warehouseInoutDao.addQuantity(t.getId());
            //删除明细
            this.delteDetail(t.getId());
            //保存新明细
            List<CmgtMaterialWarehouseInoutDetail> dlist = new ArrayList();
            t.getDetailList().forEach(d -> {
                d.setWarehouseInoutId(t.getId());
                d.setId(null);
                dlist.add(d);
            });
            //保存明细
            warehouseInoutDetailManager.saveBatch(dlist);
            //修改库存值，出库
            if ("COMPLETED".equals(t.getStatus())) {
                this.commitCK(dlist);
            }
            return res;
        }
        return res;
    }

    //提交出库相关信息
    private void commitCK(List<CmgtMaterialWarehouseInoutDetail> dlist) {
        dlist.forEach(d -> {
            //查询该仓库物资
            CmgtMaterialInfo m = materialInfoManager.getById(d.getMaterialInfoId());
            CmgtMaterialQuantity quantity = quantityManage.getById(d.getDescription());
            d.setAvailableQuantity(quantity.getQuantity());
            if (d.getQuantity().doubleValue() > quantity.getQuantity().doubleValue()) {
                throw new BadRequestException("领用数量超过了库存数量！");
            }
            quantity.setQuantity(quantity.getQuantity().subtract(d.getQuantity()));
            quantityManage.updateById(quantity);
            //减入库明细
            d.setAmount(new BigDecimal(0));
            List<CmgtMaterialWarehouseInoutDetail> rk = cmgtMaterialWarehouseInoutDetailDao.findRKDeatilsByQuantityId(quantity.getId());
            BigDecimal cksl = d.getQuantity();
            for (CmgtMaterialWarehouseInoutDetail r : rk) {
                if (r.getAvailableQuantity() != null && r.getAvailableQuantity().doubleValue() > 0) {
                    if (r.getAvailableQuantity().doubleValue() >= cksl.doubleValue()) {
                        r.setAvailableQuantity(r.getAvailableQuantity().subtract(cksl));
                        warehouseInoutDetailManager.updateById(r);
                        d.setPrice(r.getPrice());
                        d.setUnit(r.getUnit());
                        d.setModel(r.getModel());
                        d.setAmount(d.getAmount().add(cksl.multiply(r.getPrice())));
                        break;
                    } else {
                        d.setAmount(d.getAmount().add(r.getAvailableQuantity().multiply(r.getPrice())));
                        cksl = cksl.subtract(r.getAvailableQuantity());
                        r.setAvailableQuantity(new BigDecimal(0));
                        warehouseInoutDetailManager.updateById(r);
                    }
                }
            }
            //把库存ID存入出库明细中
            d.setQuantityId(quantity.getId());
            warehouseInoutDetailManager.updateById(d);
        });
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void addQuantity(List<CmgtMaterialWarehouseInoutDetail> dlist, String warehouse) {
        //遍历所有入库明细物资
        dlist.forEach(d -> {
            //查询该仓库物资
            CmgtMaterialQuantity quantity = quantityDao.findByMidAndWarhouse(d.getMaterialInfoId(), warehouse);
            CmgtMaterialInfo m = materialInfoManager.getById(d.getMaterialInfoId());
            //判断物资在该仓库是否存在
            if (quantity != null && quantity.getId() != null) {
                //此物质在该仓库存在

                quantity.setQuantity(quantity.getQuantity().add(d.getQuantity()));
                quantity.setAmount(quantity.getAmount() != null ? quantity.getAmount().add(d.getAmount()) : d.getAmount());
                quantityManage.updateById(quantity);
                //把库存ID存入出库明细中
                d.setQuantityId(quantity.getId());
                d.setAvailableQuantity(d.getQuantity());
                warehouseInoutDetailManager.updateById(d);
            } else {
                //此物质在该仓库不存在
                CmgtMaterialQuantity q = new CmgtMaterialQuantity();
                q.setClassId(m.getClassId());
                q.setMid(d.getMaterialInfoId());
                q.setName(m.getName());
                q.setWarehouse(warehouse);
                q.setUnit(m.getUnit());
                q.setQuantity(d.getQuantity());
                q.setAmount(d.getAmount());
                quantityManage.save(q);
                //把库存ID存入出库明细中
                d.setQuantityId(q.getId());
                d.setAvailableQuantity(d.getQuantity());
                warehouseInoutDetailManager.updateById(d);
            }
        });
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Boolean subtractQuantity(String wid, String warehouse) {
        Map params = new HashMap();
        params.put("wid", wid);
        params.put("warehouse", warehouse);
        return warehouseInoutDao.subtractQuantity(params);
    }


    /**
     * 根据入库单id删除明细
     *
     * @param wid
     */
    void delteDetail(String wid) {
        //删除明细
        List<CmgtMaterialWarehouseInoutDetail> list = warehouseInoutDetailManager.findMaterialDetailById(wid);
        list.forEach(l -> {
            warehouseInoutDetailManager.removeById(l.getId());
        });
    }


    @Override
    public BigDecimal getQuantity(String wid, String mid, BigDecimal nowNum) {
        Map params = new HashMap();
        params.put("wid", wid);
        params.put("qid", mid);
        params.put("nowNum", nowNum);
        return warehouseInoutDao.getQuantity(params);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Boolean removeInoutById(String... ids) {
        boolean result = false;
        //删除明细
        for (String id : ids) {
            //修改库存值，加入库存
            CmgtMaterialWarehouseInout t = getById(id);
            if ("COMPLETED".equals(t.getStatus())) {
                throw new BadRequestException("已经出入库的信息不能被删除！");
            }
            if ("0".equals(t.getDataType())) {
                //还原库存值
                subtractQuantity(t.getId(), t.getWarehouse());
            }
            if ("1".equals(t.getDataType())) {
                warehouseInoutDao.addQuantity(t.getId());
            }
            this.delteDetail(id);
            result = removeById(id);
        }
        return result;
    }

    @Transactional(rollbackFor = Exception.class)
    public void importRKData(List<Map<String, Object>> mdata) {

        List<CmgtMaterialWarehouseInout> rkds = new ArrayList<CmgtMaterialWarehouseInout>();
        for (Map<String, Object> m : mdata) {
            CmgtMaterialWarehouseInout warehouseInout = JSONUtil.toBean(JSONUtil.parseObj(m), CmgtMaterialWarehouseInout.class);
            if (warehouseInout.getSource() == null) {
                warehouseInout.setSource("未知");
            }


            String gys = warehouseInout.getSource();
            List<CmgtMaterialWarehouseInout> exRkd = rkds.stream().filter(e -> {
                return e.getSource().equals(gys);
            }).collect(Collectors.toList());
            if (exRkd.size() > 0) {
                warehouseInout = exRkd.get(0);
            } else {
                warehouseInout.setDetailList(new ArrayList<CmgtMaterialWarehouseInoutDetail>());
                warehouseInout.setDataType("0");
                warehouseInout.setWarehouse("3");
                warehouseInout.setInoutDate(LocalDate.now());
                warehouseInout.setStatus("CREATED");
                warehouseInout.setMemo("导入创建");
                warehouseInout.setSn(999);
                warehouseInout.setApplicant(ContextUtil.getCurrentUser().getFullname());
                warehouseInout.setOrgId(ContextUtil.getCurrentOrgId());
                warehouseInout.setOrg(ContextUtil.getCurrentOrgName());
                rkds.add(warehouseInout);
            }

            //System.out.println(SecurityUtils.getUsername()+"============SecurityUtils===========" + SecurityUtils.getUserDetails());
            CmgtMaterialWarehouseInoutDetail detail = JSONUtil.toBean(JSONUtil.parseObj(m), CmgtMaterialWarehouseInoutDetail.class);
            CmgtMaterialInfo materialInfo = materialInfoManager.getLikeName(detail.getName(), detail.getModel());
            if (materialInfo == null) {
                materialInfo = this.createMasterialInfo(detail);
            }
            detail.setMaterialInfoId(materialInfo.getId());
            detail.setName(materialInfo.getName());
            detail.setModel(materialInfo.getModel());
            detail.setUnit(materialInfo.getUnit());
            if (detail.getPrice() != null && detail.getQuantity() != null) {
                detail.setAmount(detail.getPrice().multiply(detail.getQuantity()));
            }
            warehouseInout.getDetailList().add(detail);
        }

        System.out.println("============rkds===========" + rkds);
        rkds.forEach(r -> {
            this.createInout(r);
        });

    }

    private CmgtMaterialInfo createMasterialInfo(CmgtMaterialWarehouseInoutDetail detail) {
        CmgtMaterialInfo materialInfo = new CmgtMaterialInfo();
        materialInfo.setName(detail.getName());
        materialInfo.setModel(detail.getModel());
        materialInfo.setPrice(detail.getPrice());
        materialInfo.setUnit(detail.getUnit());
        materialInfo.setCode(sysIdentityManager.nextId("wzbh"));
        materialInfo.setMemo("入库导入创建");
        materialInfo.setSn(999);
        materialInfoManager.create(materialInfo);
        return materialInfo;
    }
}
