package com.artfess.manage.dwd.model;

import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.UpdateGroup;
import com.artfess.manage.base.ManageBaseModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Null;
import java.time.LocalDateTime;

/**
 * dwd_sj_cq_event
 *
 * @company 阿特菲斯信息技术有限公司
 * @author yuanhc
 * @since 2022-10-08
 */
@Data
@ApiModel(value="DwdSjCqEvent对象", description="数据中台-事件表")
//@FieldRepeat(fields = {"code","name"},message = "名称不能重复，请重新输入",groups = {AddGroup.class, UpdateGroup.class})
public class DwdSjCqEvent extends ManageBaseModel<DwdSjCqEvent> {


    /** 主键_ID */
    @NotNull(message = "修改必须指定id",groups = {UpdateGroup.class})
    @Null(message = "新增不能指定id",groups = {AddGroup.class})
    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    /** 事件ID */
    @ApiModelProperty(value = "事件ID")
    @TableField("event_id")
    private String eventId;

    /** 事件来源 */
    @ApiModelProperty(value = "事件来源")
    @TableField("event_src")
    private String eventSrc;

    /** 事件源ID */
    @ApiModelProperty(value = "事件源ID")
    @TableField("event_src_id")
    private String eventSrcId;

    /** 事件名称 */
    @ApiModelProperty(value = "事件名称")
    @TableField("event_title")
    private String eventTitle;

    /** 区域ID */
    @ApiModelProperty(value = "区域ID")
    @TableField("region_id")
    private String regionId;

    /** 紧急程度 */
    @ApiModelProperty(value = "紧急程度")
    @TableField("event_level")
    private String eventLevel;

    /** 事件描述 */
    @ApiModelProperty(value = "事件描述")
    @TableField("event_desc")
    private String eventDesc;

    /** 事件发生时间 */
    @ApiModelProperty(value = "事件发生时间")
    @TableField("event_time")
    private LocalDateTime eventTime;

    /** 经纬度 */
    @ApiModelProperty(value = "经纬度")
    @TableField("lnglat")
    private String lnglat;

    /** 事件地址 */
    @ApiModelProperty(value = "事件地址")
    @TableField("event_addr")
    private String eventAddr;

    /** 创建人 */
    @ApiModelProperty(value = "创建人")
    @TableField("create_user_id")
    private String createUserId;

    /** 是否应急事件 */
    @ApiModelProperty(value = "是否应急事件")
    @TableField("emergency")
    @NotNull(message = "是否应急事件",groups = {AddGroup.class,UpdateGroup.class})
    private Integer emergency;

    /** 事件状态 */
    @ApiModelProperty(value = "事件状态")
    @TableField("event_status")
    private Integer eventStatus;

    /** 事件分类ID */
    @ApiModelProperty(value = "事件分类ID")
    @TableField("event_class_id")
    private String eventClassId;

    /** 受理时间 */
    @ApiModelProperty(value = "受理时间")
    @TableField("event_assign_time")
    private LocalDateTime eventAssignTime;

    /** 是否评估 */
    @ApiModelProperty(value = "是否评估")
    @TableField("evaluate_flag")
    private Integer evaluateFlag;

    /** 评估内容 */
    @ApiModelProperty(value = "评估内容")
    @TableField("evaluate_content")
    private String evaluateContent;

    /** 评估时间 */
    @ApiModelProperty(value = "评估时间")
    @TableField("evaluate_time")
    private LocalDateTime evaluateTime;

    /** 是否归档 */
    @ApiModelProperty(value = "是否归档")
    @TableField("archive_flag")
    private Integer archiveFlag;

    /** 归档日期 */
    @ApiModelProperty(value = "归档日期")
    @TableField("archive_time")
    private LocalDateTime archiveTime;

    @ApiModelProperty(value = "")
    @TableField("passer_name")
    private String passerName;

    @ApiModelProperty(value = "")
    @TableField("passer_phone")
    private String passerPhone;

    @ApiModelProperty(value = "")
    @TableField("dev_code")
    private String devCode;

    @ApiModelProperty(value = "")
    @TableField("dev_name")
    private String devName;

    @ApiModelProperty(value = "")
    @TableField("event_type")
    private Integer eventType;

    @ApiModelProperty(value = "")
    @TableField("people_count")
    private Integer peopleCount;

    @ApiModelProperty(value = "")
    @TableField("threshold")
    private Integer threshold;

    /** 排序 */
    @ApiModelProperty(value = "排序")
    @TableField("sn_")
    private Integer sn;

    /** 备注 */
    @ApiModelProperty(value = "备注")
    @TableField("memo_")
    private String memo;

    /** 处理人列表 */
    @ApiModelProperty(value = "处理人列表")
    @TableField("handle_user_list")
    private String handleUserList;

    /** 处理意见列表 */
    @ApiModelProperty(value = "处理意见列表")
    @TableField("handle_cont_list")
    private String handleContList;

    /** 处理时间 */
    @ApiModelProperty(value = "处理时间")
    @TableField("handle_time_list")
    private String handleTimeList;

    /** 勤务岗位区域 */
    @ApiModelProperty(value = "勤务岗位区域")
    @TableField("duty_job_id_")
    private String dutyJobId;

}
