package com.artfess.manage.dwd.model;

import com.artfess.base.entity.BaseModel;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.UpdateGroup;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Null;
import java.time.LocalDate;
import java.time.LocalDateTime;


/**
 * dwd_lk_epidemic_prevention_information
 *
 * @company 阿特菲斯信息技术有限公司
 * @author yuanhc
 * @since 2022-11-06
 */
@Data
@ApiModel(value="DwdLkEpidemicPreventionInformation对象", description="防疫信息填写")
//@FieldRepeat(fields = {"code","name"},message = "名称不能重复，请重新输入",groups = {AddGroup.class, UpdateGroup.class})
public class DwdLkEpidemicPreventionInformation extends BaseModel<DwdLkEpidemicPreventionInformation> {


    /** 主建ID */
    @NotNull(message = "修改必须指定id",groups = {UpdateGroup.class})
    @Null(message = "新增不能指定id",groups = {AddGroup.class})
    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "id", type = IdType.ASSIGN_ID)
    private String id;

    /** 姓名 */
    @ApiModelProperty(value = "姓名")
    @TableField("name")
    @NotBlank(message = "姓名",groups = {AddGroup.class,UpdateGroup.class})
    private String name;

    /** 手机号码 */
    @ApiModelProperty(value = "手机号码")
    @TableField("mobile")
    @NotBlank(message = "手机号码",groups = {AddGroup.class,UpdateGroup.class})
    private String mobile;

    /** 证件类型 */
    @ApiModelProperty(value = "证件类型")
    @TableField("type")
    @NotNull(message = "证件类型",groups = {AddGroup.class,UpdateGroup.class})
    private Integer type;

    /** 证件号 */
    @ApiModelProperty(value = "证件号")
    @TableField("id_card")
    @NotBlank(message = "证件号",groups = {AddGroup.class,UpdateGroup.class})
    private String idCard;

    /** 性别 */
    @ApiModelProperty(value = "性别")
    @TableField("sex")
    private String sex;

    /** 出生日期 */
    @ApiModelProperty(value = "出生日期")
    @TableField("date_of_birth")
    private LocalDate dateOfBirth;

    /** 是否入境人员 */
    @ApiModelProperty(value = "是否入境人员")
    @TableField("is_entry")
    private Integer isEntry;

    /** 既往行程\重点地区旅居史 */
    @ApiModelProperty(value = "既往行程重点地区旅居史")
    @TableField("journey")
    private String journey;

    /** 与确诊或疑似病例密切接触史 */
    @ApiModelProperty(value = "与确诊或疑似病例密切接触史")
    @TableField("contact_history")
    private Integer contactHistory;

    /** 是否居家隔离 */
    @ApiModelProperty(value = "是否居家隔离")
    @TableField("is_isolation")
    private Integer isIsolation;

    /** 需要咨询或帮助 */
    @ApiModelProperty(value = "需要咨询或帮助")
    @TableField("help")
    private Integer help;

    /** 创建人 */
    @ApiModelProperty(value = "创建人")
    @TableField("create_user")
    private Integer createUser;

    /** 创建时间 */
    @ApiModelProperty(value = "创建时间")
    @TableField("insert_time")
    @NotNull(message = "创建时间",groups = {AddGroup.class,UpdateGroup.class})
    private LocalDateTime insertTime;


    /** 创建时间 */
    @ApiModelProperty(value = "更新时间")
    @TableField("update_time")
    @NotNull(message = "更新时间",groups = {AddGroup.class,UpdateGroup.class})
    private LocalDateTime updateTime;

    /** 住址 */
    @ApiModelProperty(value = "住址")
    @TableField("address")
    @NotBlank(message = "住址",groups = {AddGroup.class,UpdateGroup.class})
    private String address;

    /** 来源城市 */
    @ApiModelProperty(value = "来源城市")
    @TableField("city")
    private String city;

    /** 来源地 */
    @ApiModelProperty(value = "来源地")
    @TableField("from_address")
    @NotBlank(message = "来源地",groups = {AddGroup.class,UpdateGroup.class})
    private String fromAddress;

    /** 目的地/去向 */
    @ApiModelProperty(value = "目的地/去向")
    @TableField("to_address")
    private String toAddress;

    /** 核酸报告 */
    @ApiModelProperty(value = "核酸报告")
    @TableField("report")
    private Integer report;

    /** 健康码 */
    @ApiModelProperty(value = "健康码")
    @TableField("code")
    @NotBlank(message = "健康码",groups = {AddGroup.class,UpdateGroup.class})
    private String code;

    /** 状态 */
    @ApiModelProperty(value = "状态")
    @TableField("status")
    @NotNull(message = "状态",groups = {AddGroup.class,UpdateGroup.class})
    private Integer status;

    /** 中转方式 */
    @ApiModelProperty(value = "中转方式")
    @TableField("transit_mode")
    private Integer transitMode;

    /** 登记时间 */
    @ApiModelProperty(value = "登记时间")
    @TableField("register_time")
    private LocalDateTime registerTime;

    /** 放行时间 */
    @ApiModelProperty(value = "放行时间")
    @TableField("pass_time")
    private LocalDateTime passTime;

    /** 转运时间 */
    @ApiModelProperty(value = "转运时间")
    @TableField("trans_time")
    private LocalDateTime transTime;

    /** 抵渝日期 */
    @ApiModelProperty(value = "抵渝日期")
    @TableField("arrive_time")
    private LocalDate arriveTime;

    /** 车次/航班号 */
    @ApiModelProperty(value = "车次/航班号")
    @TableField("train_no")
    private String trainNo;

    /** 备注 */
    @ApiModelProperty(value = "备注")
    @TableField("text")
    private String text;

    /** 航空公司 */
    @ApiModelProperty(value = "航空公司")
    @TableField("airline_company")
    private String airlineCompany;

    /** 航班起飞时间 */
    @ApiModelProperty(value = "航班起飞时间")
    @TableField("take_off_time")
    private LocalDateTime takeOffTime;

    /** 抵渝航班 */
    @ApiModelProperty(value = "抵渝航班")
    @TableField("airline_code")
    private String airlineCode;

    /** 是否有行李托运 */
    @ApiModelProperty(value = "是否有行李托运")
    @TableField("luggage")
    private Integer luggage;

    /** 航站楼T2/T3 */
    @ApiModelProperty(value = "航站楼T2/T3")
    @TableField("terminal")
    private String terminal;

    /** 要求 */
    @ApiModelProperty(value = "要求")
    @TableField("requirement")
    private String requirement;

    /** 前往具体地址/航班、铁路目的地 */
    @ApiModelProperty(value = "前往具体地址/航班、铁路目的地")
    @TableField("info_address")
    private String infoAddress;

    /** 市内外 */
    @ApiModelProperty(value = "市内外")
    @TableField("in_city")
    private Integer inCity;

    /** 转来方式 */
    @ApiModelProperty(value = "转来方式")
    @TableField("trans_in_type")
    private String transInType;

    /** 转走方式 */
    @ApiModelProperty(value = "转走方式")
    @TableField("trans_out_type")
    private String transOutType;

    /** 转运车牌号 */
    @ApiModelProperty(value = "转运车牌号")
    @TableField("trans_car_number")
    private String transCarNumber;

    /** 转运司机 */
    @ApiModelProperty(value = "转运司机")
    @TableField("trans_driver")
    private String transDriver;

    /** 转运电话 */
    @ApiModelProperty(value = "转运电话")
    @TableField("trans_phone")
    private String transPhone;

    /** 转运预计到达时间 */
    @ApiModelProperty(value = "转运预计到达时间")
    @TableField("trans_array_time")
    private LocalDateTime transArrayTime;

    /** 闭环类型 */
    @ApiModelProperty(value = "闭环类型")
    @TableField("trans_loop")
    private String transLoop;

    /** 转运地址 */
    @ApiModelProperty(value = "转运地址")
    @TableField("trans_address")
    private String transAddress;

    /** 转运确认时间 */
    @ApiModelProperty(value = "转运确认时间")
    @TableField("trans_receive_time")
    private LocalDateTime transReceiveTime;

    /** 删除标记 */
    @ApiModelProperty(value = "删除标记")
    @TableField("del")
    @NotNull(message = "删除标记",groups = {AddGroup.class,UpdateGroup.class})
    private Integer del;

    /** 家庭成员JSON["id":1,"name":"姓名","idCard":"身份证号"] */
    @ApiModelProperty(value = "家庭成员")
    @TableField("family_members")
    private String familyMembers;

    /** 中转确认时间 */
    @ApiModelProperty(value = "中转确认时间")
    @TableField("turn_confirm_time")
    private LocalDateTime turnConfirmTime;

    /** 人数 */
    @ApiModelProperty(value = "人数")
    @TableField("amount")
    private Integer amount;

    /** 转运地区 */
    @ApiModelProperty(value = "转运地区")
    @TableField("trans_area")
    private String transArea;

    /** 接人地点 */
    @ApiModelProperty(value = "接人地点")
    @TableField("pickup_point")
    private String pickupPoint;

    /** 等待时长 */
    @ApiModelProperty(value = "等待时长")
    @TableField("wait_time")
    private Integer waitTime;

}
