package com.artfess.manage.duty.model;

import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.UpdateGroup;
import com.artfess.manage.base.ManageBaseModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Null;
import java.time.LocalDateTime;

/**
 * cmgt_duty_vehicle_gpsinfo
 *
 * @company 阿特菲斯信息技术有限公司
 * @author yuanhc
 * @since 2022-09-24
 */
@Data
@ApiModel(value="CmgtDutyVehicleGpsinfo对象", description="车辆GPS信息")
//@FieldRepeat(fields = {"code","name"},message = "名称不能重复，请重新输入",groups = {AddGroup.class, UpdateGroup.class})
public class CmgtDutyVehicleGpsinfo extends ManageBaseModel<CmgtDutyVehicleGpsinfo> {


    /** 主键_ID */
    @NotNull(message = "修改必须指定id",groups = {UpdateGroup.class})
    @Null(message = "新增不能指定id",groups = {AddGroup.class})
    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    /** 所属车辆 */
    @ApiModelProperty(value = "所属车辆")
    @TableField("vehicle_id_")
    @NotBlank(message = "所属车辆",groups = {AddGroup.class,UpdateGroup.class})
    private String vehicleId;

    /** 车机时间 */
    @ApiModelProperty(value = "车机时间")
    @TableField("sys_time_")
    private LocalDateTime sysTime;

    /** 接收时间 */
    @ApiModelProperty(value = "接收时间")
    @TableField("receive_time_")
    private LocalDateTime receiveTime;

    /** ACC状态 */
    @ApiModelProperty(value = "ACC状态")
    @TableField("acc_status_")
    private String accStatus;

    /** GPS是否有效 */
    @ApiModelProperty(value = "GPS是否有效")
    @TableField("valid_")
    private String valid;

    /** 纬度 */
    @ApiModelProperty(value = "纬度")
    @TableField("latitude_")
    private String latitude;

    /** 经度 */
    @ApiModelProperty(value = "经度")
    @TableField("longitude_")
    private String longitude;

    /** 海拔高度 */
    @ApiModelProperty(value = "海拔高度")
    @TableField("altitude_")
    private String altitude;

    /** 卫星数 */
    @ApiModelProperty(value = "卫星数")
    @TableField("satellites_")
    private String satellites;

    /** GPS速度 */
    @ApiModelProperty(value = "GPS速度")
    @TableField("gpsspeed_")
    private String gpsspeed;

    /** 方向 */
    @ApiModelProperty(value = "方向")
    @TableField("direction_")
    private String direction;

    /** 位置精度 */
    @ApiModelProperty(value = "位置精度")
    @TableField("pdop_")
    private String pdop;

    /** 排序 */
    @ApiModelProperty(value = "排序")
    @TableField("sn_")
    private Integer sn;

    /** 备注 */
    @ApiModelProperty(value = "备注")
    @TableField("memo_")
    private String memo;

}
