package com.artfess.device.base.dao;

import com.artfess.device.base.dto.StatisticsDto;
import com.artfess.device.base.model.DeviceStatusLog;
import com.artfess.device.base.vo.DeviceStatusTimeVo;
import com.artfess.device.base.vo.StatisticsVo;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * 设备状态日志 Mapper 接口
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2022-07-15
 */
public interface DeviceStatusLogDao extends BaseMapper<DeviceStatusLog> {

    IPage<DeviceStatusLog> queryPage(IPage<DeviceStatusLog> convert2IPage, @Param(Constants.WRAPPER) Wrapper<DeviceStatusLog> convert2Wrapper);

    List<StatisticsVo> statistics(@Param("dto") StatisticsDto dto);

    IPage<DeviceStatusTimeVo> failureStatistics(IPage<DeviceStatusLog> convert2IPage, @Param(Constants.WRAPPER) Map<String, Object> params);

    List<StatisticsVo> troubleCountMonthly();

    List<StatisticsVo> statisticsCurrentTrouble();

    List<StatisticsVo> statisticsSub(@Param("dto") StatisticsDto dto);
}
