package com.artfess.device.monitor.dao;

import com.artfess.device.base.dto.StatisticsDto;
import com.artfess.device.monitor.model.DeviceDataWater;
import com.artfess.device.monitor.vo.WaterStatisticVo;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 实时监控-水位监控（DEVICE_DATA_WATER） Mapper 接口
 *
 * @company 阿特菲斯信息技术有限公司
 * @author chens
 * @since 2022-07-26
 */
public interface DeviceDataWaterDao extends BaseMapper<DeviceDataWater> {

    IPage<DeviceDataWater> query(IPage<DeviceDataWater> convert2IPage, @Param(Constants.WRAPPER) Wrapper<DeviceDataWater> convert2Wrapper);

    List<WaterStatisticVo> statistic(@Param("dto") StatisticsDto dto);
}
