/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.device.base.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.StringUtil;
import com.artfess.base.util.time.DateUtil;
import com.artfess.device.base.dao.DeviceStatusLogDao;
import com.artfess.device.base.dto.StatisticsDto;
import com.artfess.device.base.manager.DeviceStatusLogManager;
import com.artfess.device.base.model.DeviceStatusLog;
import com.artfess.device.base.utils.BizUtils;
import com.artfess.device.base.vo.DeviceStatusTimeVo;
import com.artfess.device.base.vo.StatisticsVo;
import com.artfess.sysConfig.persistence.manager.SysDictionaryManager;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class DeviceStatusLogManagerImpl
extends BaseManagerImpl<DeviceStatusLogDao, DeviceStatusLog>
implements DeviceStatusLogManager {
    @Resource
    private SysDictionaryManager sdm;

    public PageList<DeviceStatusLog> query(QueryFilter<DeviceStatusLog> queryFilter) {
        PageBean pageBean = queryFilter.getPageBean();
        IPage<DeviceStatusLog> result = ((DeviceStatusLogDao)this.baseMapper).queryPage((IPage<DeviceStatusLog>)this.convert2IPage(pageBean), (Wrapper<DeviceStatusLog>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(result);
    }

    public DeviceStatusLog getById(Serializable id) {
        QueryWrapper wrapper = (QueryWrapper)new QueryWrapper().eq((Object)"log.ID_", (Object)id);
        List result = ((DeviceStatusLogDao)this.baseMapper).queryPage((IPage<DeviceStatusLog>)new Page(1L, -1L, 1L), (Wrapper<DeviceStatusLog>)wrapper).getRecords();
        return BeanUtils.isEmpty((Object)result) ? null : (DeviceStatusLog)((Object)result.get(0));
    }

    @Override
    public List<StatisticsVo> statistics(StatisticsDto dto) {
        List rqlx = this.sdm.queryDictListItemsByCode("rqlx");
        List deviceStatus = this.sdm.queryDictListItemsByCode("sbzt");
        boolean isYear = "true".equals(dto.getIsYear());
        String inputType = dto.getDateType();
        dto.setDateType(BizUtils.getDicValueByCode(rqlx, dto.getDateType()));
        if (StringUtil.isEmpty((String)dto.getDateType())) {
            dto.setDateType("%Y-%m-%d");
        }
        List<StatisticsVo> result = new ArrayList<StatisticsVo>();
        if (isYear) {
            Map<String, List<StatisticsVo>> data = ((DeviceStatusLogDao)this.baseMapper).statistics(dto).stream().collect(Collectors.groupingBy(StatisticsVo::getStatus));
            for (Map.Entry<String, List<StatisticsVo>> d : data.entrySet()) {
                StatisticsVo rTemp = new StatisticsVo();
                rTemp.setCount(d.getValue().size());
                rTemp.setStatus(BizUtils.getDicValueByCode(deviceStatus, d.getKey()));
                result.add(rTemp);
            }
        } else {
            Map<String, Map<String, List<StatisticsVo>>> data = ((DeviceStatusLogDao)this.baseMapper).statistics(dto).stream().collect(Collectors.groupingBy(StatisticsVo::getTime, Collectors.groupingBy(StatisticsVo::getStatus)));
            for (Map.Entry<String, Map<String, List<StatisticsVo>>> d : data.entrySet()) {
                StatisticsVo rTemp = new StatisticsVo();
                rTemp.setTime(d.getKey());
                ArrayList<StatisticsVo> rtData = new ArrayList<StatisticsVo>();
                for (Map.Entry<String, List<StatisticsVo>> t : d.getValue().entrySet()) {
                    StatisticsVo rtdTemp = new StatisticsVo();
                    rtdTemp.setCount(t.getValue().size());
                    rtdTemp.setStatus(BizUtils.getDicValueByCode(deviceStatus, t.getKey()));
                    rtData.add(rtdTemp);
                }
                rTemp.setData(rtData);
                result.add(rTemp);
            }
            List<Object> emptyResult = new ArrayList();
            if ("1".equals(inputType)) {
                emptyResult = BizUtils.handleEmptyResult(12, dto.getTime(), result);
            }
            if ("2".equals(inputType)) {
                String[] inputTime = dto.getTime().split("-");
                Integer endTime = DateUtil.getDaysOfMonth((int)Integer.parseInt(inputTime[0]), (int)Integer.parseInt(inputTime[1]));
                emptyResult = BizUtils.handleEmptyResult(endTime, dto.getTime(), result);
            }
            result.addAll(emptyResult);
            result = result.stream().sorted(Comparator.comparing(StatisticsVo::getTime)).collect(Collectors.toList());
        }
        return result;
    }

    @Override
    public List<StatisticsVo> statisticsSub(StatisticsDto dto) {
        Assert.notNull((Object)dto, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.notNull((Object)dto.getDateType(), (String)"\u65e5\u671f\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.notNull((Object)dto.getTime(), (String)"\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.notNull((Object)dto.getDeviceStatus(), (String)"\u8bbe\u5907\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        List rqlx = this.sdm.queryDictListItemsByCode("rqlx");
        dto.setDateType(BizUtils.getDicValueByCode(rqlx, dto.getDateType()));
        if (StringUtil.isEmpty((String)dto.getDateType())) {
            throw new RuntimeException("\u672a\u5b9a\u4e49\u7684\u65e5\u671f\u7c7b\u578b\uff01");
        }
        return ((DeviceStatusLogDao)this.baseMapper).statisticsSub(dto);
    }

    @Override
    public List<StatisticsVo> statisticsTrouble(StatisticsDto dto) {
        List deviceType = this.sdm.queryDictListItemsByCode("sblx");
        List rqlx = this.sdm.queryDictListItemsByCode("rqlx");
        dto.setDeviceStatus("2");
        dto.setDateType(BizUtils.getDicValueByCode(rqlx, dto.getDateType()));
        if (StringUtil.isEmpty((String)dto.getDateType())) {
            dto.setDateType("%Y-%m-%d");
        }
        ArrayList<StatisticsVo> result = new ArrayList<StatisticsVo>();
        Map<String, List<StatisticsVo>> data = ((DeviceStatusLogDao)this.baseMapper).statistics(dto).stream().collect(Collectors.groupingBy(StatisticsVo::getType));
        for (Map.Entry<String, List<StatisticsVo>> t : data.entrySet()) {
            StatisticsVo vo = new StatisticsVo();
            vo.setType(BizUtils.getDicValueByCode(deviceType, t.getKey()));
            vo.setCount(t.getValue().size());
            result.add(vo);
        }
        return result;
    }

    @Override
    public List<StatisticsVo> statisticsCurrentTrouble() {
        return ((DeviceStatusLogDao)this.baseMapper).statisticsCurrentTrouble();
    }

    @Override
    public List<StatisticsVo> troubleCountMonthly() {
        return ((DeviceStatusLogDao)this.baseMapper).troubleCountMonthly();
    }

    @Override
    public PageList<DeviceStatusTimeVo> timeStatistics(QueryFilter<DeviceStatusLog> queryFilter) {
        PageBean pageBean = queryFilter.getPageBean();
        Map params = queryFilter.getParams();
        IPage<DeviceStatusTimeVo> result = ((DeviceStatusLogDao)this.baseMapper).failureStatistics((IPage<DeviceStatusLog>)this.convert2IPage(pageBean), params);
        result.getRecords().forEach(deviceStatusTimeVo -> {
            if (!"0".equals(deviceStatusTimeVo.getTimeLength())) {
                deviceStatusTimeVo.setTimeLength((int)Math.floor(Integer.parseInt(deviceStatusTimeVo.getTimeLength()) / 60) + "\u65f6" + Integer.parseInt(deviceStatusTimeVo.getTimeLength()) % 60 + "\u5206");
            }
            if (!"0".equals(deviceStatusTimeVo.getTimeLength1())) {
                deviceStatusTimeVo.setTimeLength1((int)Math.floor(Integer.parseInt(deviceStatusTimeVo.getTimeLength1()) / 60) + "\u65f6" + Integer.parseInt(deviceStatusTimeVo.getTimeLength1()) % 60 + "\u5206");
            }
        });
        return new PageList(result);
    }
}

