package com.artfess.manage.safty.model;

import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.UpdateGroup;
import com.artfess.manage.base.ManageBaseModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Null;
import java.time.LocalDateTime;

/**
 * cmgt_safty_training_record
 *
 * @company 阿特菲斯信息技术有限公司
 * @author yuanhc
 * @since 2022-09-03
 */
@Data
@ApiModel(value="CmgtSaftyTrainingRecord对象", description="安全培训记录")
//@FieldRepeat(fields = {"code","name"},message = "名称不能重复，请重新输入",groups = {AddGroup.class, UpdateGroup.class})
public class CmgtSaftyTrainingRecord extends ManageBaseModel<CmgtSaftyTrainingRecord> {


    /** 培训时间 */
    @ApiModelProperty(value = "培训时间")
    @TableField("training_date_")
    @NotNull(message = "培训时间",groups = {AddGroup.class,UpdateGroup.class})
    private LocalDateTime trainingDate;

    /** 主键_ID */
    @NotNull(message = "修改必须指定id",groups = {UpdateGroup.class})
    @Null(message = "新增不能指定id",groups = {AddGroup.class})
    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    /** 培训项目 */
    @ApiModelProperty(value = "培训项目")
    @TableField("training_project_id_")
    @NotBlank(message = "培训项目",groups = {AddGroup.class,UpdateGroup.class})
    private String trainingProjectId;

    /** 培训讲师 */
    @ApiModelProperty(value = "培训讲师")
    @TableField("teacher_")
    private String teacher;

    /** 关联计划 */
    @ApiModelProperty(value = "关联计划")
    @TableField("training_plan_id_")
    private String trainingPlanId;

    /** 培训对象 */
    @ApiModelProperty(value = "培训对象")
    @TableField("trainee_")
    @NotBlank(message = "培训对象",groups = {AddGroup.class,UpdateGroup.class})
    private String trainee;

    /** 培训地点 */
    @ApiModelProperty(value = "培训地点")
    @TableField("location_")
    private String location;

    /** 培训内容 */
    @ApiModelProperty(value = "培训内容")
    @TableField("content_")
    @NotBlank(message = "培训内容",groups = {AddGroup.class,UpdateGroup.class})
    private String content;

    /** 培训总结 */
    @ApiModelProperty(value = "培训总结")
    @TableField("summary_")
    private String summary;

    /** 排序 */
    @ApiModelProperty(value = "排序")
    @TableField("sn_")
    private Integer sn;

    /** 备注 */
    @ApiModelProperty(value = "备注")
    @TableField("memo_")
    private String memo;

}
